package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 角色
 */
@TableName("EASYAPI_ROLE")
public class DBRoleEntity extends BaseDbEntity {

    @DDL(value = "ROLE_NAME",ddl = "`ROLE_NAME` varchar(50) DEFAULT NULL COMMENT '角色名称'")
    @ApidocComment("角色名称")
    private String roleName;

    @DDL(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '角色说明'")
    @ApidocComment("角色说明")
    private String description;

    @DDL(value = "DEFAULT_ROLE",ddl = "`DEFAULT_ROLE` int(1) DEFAULT 0 COMMENT '是否默认角色：0-否 1-是'")
    @ApidocComment("是否默认角色：0-否 1-是")
    private Integer defaultRole;

    @DDL(value = "SUPER_ADMIN_STATUS",ddl = "`SUPER_ADMIN_STATUS` int(1) DEFAULT 0 COMMENT '是否超级管理员:0-不是  1-是'")
    @ApidocComment("是否超级管理员:0-不是  1-是")
    private Integer superAdminStatus;

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSuperAdminStatus() {
        return superAdminStatus;
    }

    public void setSuperAdminStatus(Integer superAdminStatus) {
        this.superAdminStatus = superAdminStatus;
    }

    public Integer getDefaultRole() {
        return defaultRole;
    }

    public void setDefaultRole(Integer defaultRole) {
        this.defaultRole = defaultRole;
    }
}
