package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 项目
 */
@TableName("EASYAPI_PROJECT")
public class DBProjectEntity extends BaseDbEntity {

    @DDL(value = "TITLE",ddl="`TITLE` varchar(100) DEFAULT NULL COMMENT '项目标题'")
    @ApidocComment("项目标题")
    private String title;

    @DDL(value = "PROJECT_NAME",ddl = "`PROJECT_NAME` varchar(100) DEFAULT NULL COMMENT '项目名称'")
    @ApidocComment("项目名称")
    private String projectName;

    @DDL(value = "PROJECT_UNIQUE",ddl = "`PROJECT_UNIQUE` varchar(50) DEFAULT NULL COMMENT '唯一标识'")
    @ApidocComment("唯一标识")
    private String projectUnique;

    @DDL(value = "APP_SECRET",ddl = "`APP_SECRET` varchar(50) DEFAULT NULL COMMENT '项目密钥'")
    @ApidocComment("项目密钥")
    private String appSecret;


    @TableField(exist = false)
    private String indexBanner;

    @DDL(value = "INDEX_BANNER_BYTES",type = Blob.class,ddl = "`INDEX_BANNER_BYTES` BLOB DEFAULT NULL COMMENT '项目首页广告内容'")
    @ApidocComment("项目首页广告内容")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] indexBannerBytes;

    @TableField(exist = false)
    private String description;

    @DDL(value = "DESCRIPTION_BYTES",type = Blob.class,ddl = "`DESCRIPTION_BYTES` BLOB DEFAULT NULL COMMENT '项目介绍'")
    @ApidocComment("项目介绍")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] descriptionBytes;

    @TableField(exist = false)
    private String imgs;

    @DDL(value = "IMGS_BYTES",type = Blob.class,ddl = "`IMGS_BYTES` BLOB DEFAULT NULL COMMENT '项目图片'")
    @ApidocComment("项目图片")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] imgsBytes;

    @DDL(value = "PROJECT_DISABLE",ddl = "`PROJECT_DISABLE` int(1) DEFAULT 0 COMMENT '项目状态:0-正常  1-关闭'")
    @ApidocComment("项目状态:0-正常  1-关闭")
    private Integer projectDisable;

    @DDL(value = "DEFAULT_STATUS",ddl="`DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '是否默认项目 0-不是  1-是'")
    @ApidocComment("是否默认项目 0-不是  1-是")
    private Integer defaultStatus;

    @DDL(value = "ENABLE_REQ_PACKAGE",ddl = "`ENABLE_REQ_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启请求参数外包装 0-否  1-是'")
    @ApidocComment("是否开启请求参数外包装 0-不是  1-是")
    private Integer enableReqPackage;

    @DDL(value = "ENABLE_RES_PACKAGE",ddl = "`ENABLE_RES_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启返回参数外包装 0-否  1-是'")
    @ApidocComment("是否开启返回参数外包装 0-不是  1-是")
    private Integer enableResPackage;

    @DDL(value = "ENABLE_ONLY_REQUEST_URL",ddl = "`ENABLE_ONLY_REQUEST_URL` int(1) DEFAULT 0 COMMENT '是否开启统一接口路径 0-不是  1-是 0-否  1-是'")
    @ApidocComment("是否开启统一接口路径 0-不是  1-是")
    private Integer enableOnlyRequestUrl;

    @DDL(value = "ONLY_REQUEST_URL",ddl = "`ONLY_REQUEST_URL` varchar(255) DEFAULT NULL COMMENT '统一接口路径地址'")
    @ApidocComment("统一接口路径地址")
    private String onlyRequestUrl;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectUnique() {
        return projectUnique;
    }

    public void setProjectUnique(String projectUnique) {
        this.projectUnique = projectUnique;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getIndexBanner() {
        return indexBanner;
    }

    public void setIndexBanner(String indexBanner) {
        this.indexBanner = indexBanner;
        this.indexBannerBytes = StringUtil.isEmpty(indexBanner)?null:indexBanner.getBytes(Charsets.UTF_8);
    }

    public byte[] getIndexBannerBytes() {
        return indexBannerBytes;
    }

    public void setIndexBannerBytes(byte[] indexBannerBytes) {
        this.indexBannerBytes = indexBannerBytes;
        this.indexBanner = indexBannerBytes==null?null:new String(indexBannerBytes,Charsets.UTF_8);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionBytes = StringUtil.isEmpty(description)?null:description.getBytes(Charsets.UTF_8);
    }

    public byte[] getDescriptionBytes() {
        return descriptionBytes;
    }

    public void setDescriptionBytes(byte[] descriptionBytes) {
        this.descriptionBytes = descriptionBytes;
        this.description = descriptionBytes==null?null:new String(descriptionBytes,Charsets.UTF_8);
    }

    public String getImgs() {
        return imgs;
    }

    public void setImgs(String imgs) {
        this.imgs = imgs;
        this.imgsBytes = StringUtil.isEmpty(imgs)?null:imgs.getBytes(Charsets.UTF_8);
    }

    public byte[] getImgsBytes() {
        return imgsBytes;
    }

    public void setImgsBytes(byte[] imgsBytes) {
        this.imgsBytes = imgsBytes;
        this.imgs = imgsBytes==null?null:new String(imgsBytes,Charsets.UTF_8);
    }

    public Integer getProjectDisable() {
        return projectDisable;
    }

    public void setProjectDisable(Integer projectDisable) {
        this.projectDisable = projectDisable;
    }

    public Integer getDefaultStatus() {
        return defaultStatus;
    }

    public void setDefaultStatus(Integer defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public Integer getEnableReqPackage() {
        return enableReqPackage;
    }

    public void setEnableReqPackage(Integer enableReqPackage) {
        this.enableReqPackage = enableReqPackage;
    }

    public Integer getEnableResPackage() {
        return enableResPackage;
    }

    public void setEnableResPackage(Integer enableResPackage) {
        this.enableResPackage = enableResPackage;
    }

    public Integer getEnableOnlyRequestUrl() {
        return enableOnlyRequestUrl;
    }

    public void setEnableOnlyRequestUrl(Integer enableOnlyRequestUrl) {
        this.enableOnlyRequestUrl = enableOnlyRequestUrl;
    }

    public String getOnlyRequestUrl() {
        return onlyRequestUrl;
    }

    public void setOnlyRequestUrl(String onlyRequestUrl) {
        this.onlyRequestUrl = onlyRequestUrl;
    }
}