package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.entity.db.doc.DBParamEntity;
import cn.easyutil.easyapi.util.StringUtil;

import java.util.List;
import java.util.UUID;

public class DocParamEntity extends DBParamEntity {

    private String uuid;

    private List<DocParamEntity> children;

    public DocParamEntity(){
        this.uuid = UUID.randomUUID().toString();
        this.setUnique(this.uuid);
    }

    public List<DocParamEntity> getChildren() {
        return children;
    }

    public void setChildren(List<DocParamEntity> children) {
        this.children = children;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        if(!StringUtil.isEmpty(this.uuid)){
            return ;
        }
        this.uuid = uuid;
    }
}
