package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.util.StringUtil;
import org.apache.http.entity.ContentType;

/**
 * 请求体类型
 */
public enum BodyType {
    //0-form  1-json体  2-文件上传 3-XML 4-RAW 5-文件下载
    FORM(0,ContentType.APPLICATION_FORM_URLENCODED),
    JSON(1,ContentType.APPLICATION_JSON),
    UPLOAD(2,ContentType.APPLICATION_FORM_URLENCODED),
    XML(3,ContentType.APPLICATION_XML),
    RAW(4,ContentType.TEXT_PLAIN),
    DOWNLOAD(5,ContentType.APPLICATION_OCTET_STREAM),
    UNKNOW(-1,null);

    private Integer type;

    private ContentType contentType;

    BodyType(Integer type,ContentType contentType){
        this.type = type;
        this.contentType = contentType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public ContentType getContentType() {
        return contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public static BodyType parse(Integer type){
        if(StringUtil.isEmpty(type)){
            return UNKNOW;
        }
        BodyType[] values = BodyType.values();
        for (BodyType value : values) {
            if(value.getType().equals(type)){
                return value;
            }
        }
        return UNKNOW;
    }
}
