package cn.easyutil.easyapi.content;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 接口文档可授予的权限
 */
public enum AuthModuleButtonsEnum {

    doc_interface("文档-接口详情","doc_interface","doc_interface",1),
    doc_interface_source("查看源码","doc_interface","doc_interface_source"),
    doc_interface_update("修改接口信息","doc_interface","doc_interface_update"),
    doc_interface_del("删除接口","doc_interface","doc_interface_del"),

    doc_request("文档-请求参数","doc_request","doc_request",1),
    doc_request_template("查看示例","doc_request","doc_request_template",1),
    doc_request_export("导出代码","doc_request","doc_request_export",1),
    doc_request_update("编辑参数","doc_request","doc_request_update"),

    doc_response("文档-响应参数","doc_response","doc_response",1),
    doc_response_template("查看示例","doc_response","doc_response_template",1),
    doc_response_export("导出代码","doc_response","doc_response_export",1),
    doc_response_update("编辑参数","doc_response","doc_response_update"),

    doc_mock("文档-模拟请求","doc_mock","doc_mock",1),

    manage_sync("管理-同步管理","manage_sync","manage_sync"),
    manage_sync_update("修改同步密钥","manage_sync","manage_sync_update"),
    manage_sync_create("创建同步任务","manage_sync","manage_sync_create"),

    manage_project("管理-项目管理","manage_project","manage_project"),
    manage_project_update("修改项目信息","manage_project","manage_project_update"),
    manage_project_export("导出项目","manage_project","manage_project_export"),

    manage_user("管理-用户管理","manage_user","manage_user"),
    manage_user_create("创建用户","manage_user","manage_user_create"),
    manage_user_auth("用户授权","manage_user","manage_user_auth"),
    manage_user_update("修改用户信息","manage_user","manage_user_update"),
    manage_user_del("删除用户","manage_user","manage_user_del"),

    manage_header("管理-请求头管理","manage_header","manage_header",1),
    manage_header_create("添加请求头","manage_header","manage_header_create",1),
    manage_header_update("修改请求头","manage_header","manage_header_update",1),
    manage_header_del("删除请求头","manage_header","manage_header_del",1),

    manage_host("管理-请求环境管理","manage_host","manage_host"),
    manage_host_create("添加请求环境","manage_host","manage_host_create"),
    manage_host_update("修改请求环境","manage_host","manage_host_update"),
    manage_host_del("删除请求环境","manage_host","manage_host_del"),

    manage_env("管理-环境变量管理","manage_env","manage_env",1),
    manage_env_create("添加环境变量","manage_env","manage_env_create",1),
    manage_env_update("修改环境变量","manage_env","manage_env_update",1),
    manage_env_del("删除环境变量","manage_env","manage_env_del",1),

    manage_script("管理-脚本管理","manage_script","manage_script",1),
    manage_script_create("添加脚本","manage_script","manage_script_create",1),
    manage_script_update("修改脚本","manage_script","manage_script_update",1),
    manage_script_del("删除脚本","manage_script","manage_script_del",1),

    manage_package("管理-参数包装管理","manage_package","manage_package",1),
    manage_package_create("添加参数包装","manage_package","manage_package_create",1),
    manage_package_update("修改参数包装","manage_package","manage_package_update",1),
    manage_package_del("删除参数包装","manage_package","manage_package_del",1),

    unknown(null,null,null);

    //按钮名称
    private final String name;
    //所属模块菜单
    private final String module;
    //按钮编码
    private final String code;
    //是否默认权限
    private final Integer defaultStatus;

    AuthModuleButtonsEnum(String name, String module, String code,Integer defaultStatus) {
        this.name = name;
        this.module = module;
        this.code = code;
        this.defaultStatus = defaultStatus;
    }

    AuthModuleButtonsEnum(String name, String module, String code) {
        this(name,module,code,0);
    }

    public static List<AuthModuleButtonsEnum> getByModule(String module){
        List<AuthModuleButtonsEnum> list = new ArrayList<>();
        for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
            if(value.getModule().equals(module)){
                list.add(value);
            }
        }
        return list;
    }

    public static AuthModuleButtonsEnum getByCode(String code){
        for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
            if(value.getModule().equals(code)){
                return value;
            }
        }
        return null;
    }

    public static List<AuthModuleBean> getModules(Set<String> checked){
        List<AuthModuleBean> list = new ArrayList<>();
        List<AuthModuleButtonsEnum> modules = Stream.of(AuthModuleButtonsEnum.values())
                .filter(e -> e.getModule() != null && e.getModule().equals(e.getCode()))
                .collect(Collectors.toList());

        for (AuthModuleButtonsEnum module : modules) {
            AuthModuleBean bean = new AuthModuleBean();
            bean.setModuleName(module.getName());
            bean.setModuleCode(module.getCode());
            bean.setChecked(0);
            if(checked!=null && checked.contains(module.getCode())){
                bean.setChecked(1);
            }
            bean.setChildren(new ArrayList<>());
            for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
                if(value == unknown){
                    continue;
                }
                if(value.getModule().equals(module.getCode()) && !value.getCode().equals(module.getCode())){
                    AuthModuleBean children = new AuthModuleBean();
                    children.setChecked(0);
                    if(checked!=null && checked.contains(value.getCode())){
                        children.setChecked(1);
                    }
                    children.setModuleName(value.getName());
                    children.setModuleCode(value.getCode());
                    bean.getChildren().add(children);
                }
            }
            list.add(bean);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public String getModule() {
        return module;
    }

    public String getCode() {
        return code;
    }

    public Integer getDefaultStatus() {
        return defaultStatus;
    }
}
