package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.*;
import cn.easyutil.easyapi.content.AuthModuleButtonsEnum;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.*;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.mybatis.service.*;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.context.ApplicationContext;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocCreatePre {

    /**
     * 项目配置文件
     */

    private AllConfiguration all;

    private ApplicationContext appContext;

    private final ArticleService articleService = new ArticleService();

    private final ProjectService projectService = new ProjectService();

    private final ModuleService moduleService = new ModuleService();

    private final UserService userService = new UserService();

    private final RoleService roleService = new RoleService();

    private final DictService dictService = new DictService();

    private final HostService hostService = new HostService();

    private final RoleProjectService roleProjectService = new RoleProjectService();

    private final UserTemporaryAuthService userTemporaryAuthService = new UserTemporaryAuthService();

    private final RoleAuthService roleAuthService = new RoleAuthService();

    public static DocCreatePre build(AllConfiguration all, ApplicationContext appContext){
        DocCreatePre pre = new DocCreatePre();
        pre.all = all;
        pre.appContext = appContext;
        return pre;
    }

    /**
     * 初始化
     */
    public void pre() {
        initProject();
        getRomoteBannerAndDoc();
        showLogo();

    }

    private void getRomoteBannerAndDoc(){
        //添加默认文章
        addDefaultArticles();
    }

    private void addDefaultArticles(){
        List<DBArticleEntity> articles = new ArrayList<>();
        DBArticleEntity a1 = new DBArticleEntity();
        a1.setTitle("欢迎使用easyapi");
        a1.setContent("小明，起来致欢迎辞");
        articles.add(a1);

        DBArticleEntity a2 = new DBArticleEntity();
        a2.setTitle("如何使用自定义变量");
        a2.setContent("在任意输入框中填写 {{变量名}} 即可");
        articles.add(a2);

        DBArticleEntity a3 = new DBArticleEntity();
        a3.setTitle("如何切换请求环境");
        a3.setContent("在顶部设置里面有请求环境设置，可以增删环境，同时在接口模拟请求页面选择环境");
        articles.add(a3);

        articleService.saveBatch(articles);
    }

    /**
     * 初始化项目
     */
    private void initProject(){
        DBProjectEntity query = projectService.getOne(Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getProjectUnique, all.getConfiguration().getUnique()));
        if(query != null){
            //已经有项目了，不需要创建
            return ;
        }
        int count = projectService.count();
        //创建项目
        DBProjectEntity project = addDefaultProject(count>0?0:1);
        //创建模块
        DBModuleEntity module = addDefaultModule(project);
        DBUserEntity admin = userService.getOne(
                Wrappers.lambdaQuery(DBUserEntity.class)
                        .eq(DBUserEntity::getAccount, "admin"));
        if(admin == null){
            addDefaultUsers(module);
        }else{
            admin.setAccount(all.getUserConfiguration().getAccount());
            admin.setPassword(StringUtil.toMD5(all.getUserConfiguration().getPassword()));
            userService.updateById(admin);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getProjectName();
        ProjectContext.currentModuleName = module.getName();

        DBDictEntity syncEnable = new DBDictEntity();
        syncEnable.setDictKey(DBDictEntity.syncStatusKey());
        syncEnable = dictService.getOne(Wrappers.lambdaQuery(syncEnable),false);
        if(syncEnable == null){
            syncEnable = new DBDictEntity();
            syncEnable.setDictKey(DBDictEntity.syncStatusKey());
            syncEnable.setDictVal("0");
            dictService.save(syncEnable);
        }

        DBDictEntity syncInterfaces = new DBDictEntity();
        syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
        syncInterfaces = dictService.getOne(Wrappers.lambdaQuery(syncInterfaces),false);
        if(syncInterfaces == null){
            syncInterfaces = new DBDictEntity();
            syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
            syncInterfaces.setDictVal("[]");
            dictService.save(syncInterfaces);
        }

        DBDictEntity syncInfo = new DBDictEntity();
        syncInfo.setDictKey(DBDictEntity.syncInfoKey());
        syncInfo = dictService.getOne(Wrappers.lambdaQuery(syncInfo),false);
        if(syncInfo == null){
            syncInfo = new DBDictEntity();
            syncInfo.setDictKey(DBDictEntity.syncInfoKey());
            syncInfo.setDictVal(JsonUtil.beanToJson(new OpenSyncDto()));
            dictService.save(syncInfo);
        }

        DBDictEntity syncSecret = new DBDictEntity();
        syncSecret.setDictKey(DBDictEntity.syncSecretKey());
        syncSecret = dictService.getOne(Wrappers.lambdaQuery(syncSecret),false);
        if(syncSecret == null){
            syncSecret = new DBDictEntity();
            syncSecret.setDictKey(DBDictEntity.syncSecretKey());
            syncSecret.setDictVal(all.getConfiguration().getSyncSecret());
            dictService.save(syncSecret);
        }

        all.getConfiguration().setSyncSecret(syncSecret.getDictVal());
        all.getConfiguration().setUnique(project.getProjectUnique());
    }

    /**
     * 展示logo
     */
    private void showLogo() {
        String text = "                                        _\n" +
                "                                       (_)\n" +
                "  ___  __ _ ___ _   _ ______ __ _ _ __  _\n" +
                " / _ \\/ _` / __| | | |______/ _` | '_ \\| |\n" +
                "|  __/ (_| \\__ \\ |_| |     | (_| | |_) | |\n" +
                " \\___|\\__,_|___/\\__, |      \\__,_| .__/|_|\n" +
                "                 __/ |           | |\n" +
                "                |___/            |_|\n" +
                "    -------------------------------接口文档-v0.8.0\n" +
                "    ---http://localhost:项目端口/apidoc.html";
        System.out.println(text);
    }

    /**
     * 初始化项目
     */
    private DBModuleEntity addDefaultModule(DBProjectEntity project){
        //初始化项目模块
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("默认模块");
        module.setDescription("初始化项目模块");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(project.getDefaultStatus());
        moduleService.save(module);
        if(project.getDefaultStatus() == 0){
            return module;
        }

        //初始化项目请求环境
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock请求,返回mock结果");
        mock.setDefaultStatus(project.getDefaultStatus());
        mock.setDisable(0);
        mock.setCanDelete(0);
        String port = appContext.getEnvironment().getProperty("server.port");
        port = port==null?"8080":port;
        mock.setHost("mock");
        hostService.save(mock);

        //添加本地环境
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("本地环境");
        local.setDescription("本机环境");
        local.setDefaultStatus(0);
        local.setDisable(0);
        mock.setCanDelete(1);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException ignored) {
        }
        local.setHost("http://"+address+":"+port);
        hostService.save(local);
        return module;
    }

    /**
     * 初始化项目
     */
    private DBProjectEntity addDefaultProject(Integer defaultStatus) {
        //初始化项目
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(defaultStatus);
        project.setTitle(all.getConfiguration().getProjectName());
        project.setProjectName(all.getConfiguration().getProjectName());
        project.setProjectUnique(all.getConfiguration().getUnique());
        project.setAppSecret(all.getConfiguration().getSyncSecret());
        projectService.save(project);
        return project;
    }

    /**
     * 添加默认用户
     */
    private void addDefaultUsers(DBModuleEntity module) {

        //添加管理员账户
        DBUserEntity user = new DBUserEntity();
        user.setAccount(all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("超级管理员");
        user.setNickName("超级管理员");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setHidden(1);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        userService.save(user);
        userTemporaryAuthService.binds(user, Stream.of(AuthModuleButtonsEnum.values()).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));

        //添加特殊超级管理员，该人员不可登陆，仅用作远程通讯
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setHidden(1);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        userService.save(hiddenUser);

        //添加测试账号角色
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("测试人员");
        testRole.setDescription("仅提供测试相关的权限");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        roleService.save(testRole);

        //添加角色对应的项目
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        roleProjectService.save(roleProject);

        //添加角色对应的可操作功能
        List<Integer> defaultAuthCodes = AuthMoudle.getDefaultAuthCodes();
        List<DBRoleAuthEntity> auths = new ArrayList<>();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        roleAuthService.saveBatch(auths);

        //添加测试人员
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("测试账号");
        test.setDescription("测试人员账号");
        test.setDisable(0);
        userService.save(test);
        userTemporaryAuthService.binds(test,Stream.of(AuthModuleButtonsEnum.values()).filter(item -> item.getDefaultStatus()==1).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
    }
}
