package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.List;

/**
 * 复杂测试配置类
 */
@TableName("EASYAPI_COMPLEX_TEST_GROUP")
public class DBComplexTestGroupEntity extends BaseDbEntity {

    @DDL(value = "INTERFACE_ID",ddl = "`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @DDL(value = "NAME",ddl = "`NAME` varchar(255) DEFAULT NULL COMMENT '配置名称'")
    @ApidocComment("配置名称")
    private String name;

    @DDL(value = "THREAD_COUNT",ddl = "`THREAD_COUNT` int(10) DEFAULT NULL COMMENT '线程数'")
    @ApidocComment("线程数")
    private Integer threadCount;

    @DDL(value = "REQUEST_HEADERS",ddl = "`REQUEST_HEADERS` varchar(255) DEFAULT NULL COMMENT '请求头'")
    @ApidocComment("请求头")
    private String requestHeaders;

    @DDL(value = "REQUEST_PARAM",ddl = "`REQUEST_PARAM` varchar(255) DEFAULT NULL COMMENT '请求参数'")
    @ApidocComment("请求参数")
    private String requestParam;

    @DDL(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public String getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestParam() {
        return requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }
}
