package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import com.baomidou.mybatisplus.annotation.TableName;


/**
 * 模块访问环境配置
 */
@TableName("EASYAPI_MODULE_HOST")
public class DBModuleHostEntity extends BaseDbEntity {

	@DDL(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
	@ApidocComment("模块id")
	private Long moduleId;

	@DDL(value = "NAME",ddl = "`NAME` varchar(50) DEFAULT NULL COMMENT '环境名称'")
	@ApidocComment("环境名称")
	private String name;

	@DDL(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '环境描述'")
	@ApidocComment("环境描述")
	private String description;

	@DDL(value = "HOST",ddl = "`HOST` varchar(255) DEFAULT NULL COMMENT '环境ip或域名'")
	@ApidocComment("环境ip或域名")
	private String host;

	@DDL(value = "DISABLE",ddl = "`DISABLE` int(1) DEFAULT 0 COMMENT '环境状态:0-正常  1-关闭'")
	@ApidocComment("环境状态:0-正常  1-关闭")
	private Integer disable;

	@DDL(value = "CAN_DELETE",ddl = "`CAN_DELETE` int(1) DEFAULT 1 COMMENT '是否可删除  0-不可删除  1-可以删除'")
	@ApidocComment("是否可删除  0-不可删除  1-可以删除")
	private Integer canDelete;

	@DDL(value = "DEFAULT_STATUS",ddl = "`DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '是否默认环境 0-不是  1-是'")
	@ApidocComment("是否默认环境 0-不是  1-是")
	private Integer defaultStatus;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public Integer getDisable() {
		return disable;
	}

	public void setDisable(Integer disable) {
		this.disable = disable;
	}

	public Integer getDefaultStatus() {
		return defaultStatus;
	}

	public void setDefaultStatus(Integer defaultStatus) {
		this.defaultStatus = defaultStatus;
	}

	public Integer getCanDelete() {
		return canDelete;
	}

	public void setCanDelete(Integer canDelete) {
		this.canDelete = canDelete;
	}
}
