package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 字典表
 */
@TableName("EASYAPI_DICT")
public class DBDictEntity extends BaseDbEntity {

    @DDL(value = "DICT_KEY",ddl="`DICT_KEY` varchar(100) DEFAULT NULL COMMENT 'KEY'")
    @ApidocComment("key")
    private String dictKey;

    @TableField(exist = false)
    private String dictVal;

    @DDL(value = "DICT_VAL_BYTES",type = Blob.class,ddl="`DICT_VAL_BYTES` BLOB DEFAULT NULL COMMENT 'DICT_VAL'")
    @ApidocComment("dictVal")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] dictValBytes;

    @DDL(value = "ATTACH",ddl="`ATTACH` varchar(255) DEFAULT NULL COMMENT '冗余信息'")
    @ApidocComment("attach")
    private String attach;

    @DDL(value = "REMARK",ddl="`REMARK` varchar(100) DEFAULT NULL COMMENT '描述'")
    @ApidocComment("remark")
    private String remark;

    public String getDictKey() {
        return dictKey;
    }

    public void setDictKey(String dictKey) {
        this.dictKey = dictKey;
    }

    public String getDictVal() {
        return dictVal;
    }

    public void setDictVal(String dictVal) {
        this.dictVal = dictVal;
        this.dictValBytes = StringUtil.isEmpty(dictVal)?null:dictVal.getBytes(Charsets.UTF_8);
    }

    public byte[] getDictValBytes() {
        return dictValBytes;
    }

    public void setDictValBytes(byte[] dictValBytes) {
        this.dictValBytes = dictValBytes;
        this.dictVal = this.dictValBytes==null?null:new String(this.dictValBytes,Charsets.UTF_8);
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public static String syncStatusKey(){
        return "sync_status";
    }
    public static String syncInterfacesKey(){
        return "sync_interfaces";
    }
    public static String syncInfoKey(){
        return "sync_info";
    }
    public static String syncSecretKey(){
        return "sync_secret";
    }
}
