package cn.easyutil.easyapi;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiDataConfiguration;
import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.DBTables;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.operator.*;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.logic.run.DocCreate;
import cn.easyutil.easyapi.logic.run.DocCreatePost;
import cn.easyutil.easyapi.logic.run.DocCreatePre;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.context.ApplicationContext;

import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

public class EasyapiRun {

    public static void run(AllConfiguration all,ApplicationContext appContext){
        EasyApiBaseConfiguration configuration = all.getConfiguration();
        configuration.getUnique();
        if(!configuration.isEnable()){
            return ;
        }
        try {
            initBase(all);
            initDataSource(all);
            //文档生成前置处理
            DocCreatePre.build(all, appContext).pre();
            DocCreate instance = new DocCreate(all,appContext);
            if(configuration.isRescan()){
                instance.createApi();
            }
            //文档生成后置处理
            DocCreatePost.build(all, appContext).post();
            System.out.println("*********************************************");
            System.out.println("**********   接口文档已生成 url=/apidoc.html  ***************");
            System.out.println("*********************************************");
        }catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("接口文档生成失败",e);
        }
    }

    private static void initBase(AllConfiguration all){

        ProjectContext.allConfiguration = all;
        Set<String> projectSourcePaths = all.getConfiguration().getProjectSourcePaths();
        String filePost = File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        if(projectSourcePaths.isEmpty()){
            try {
                String path = new File("").getCanonicalPath();
                projectSourcePaths.add(path+ filePost);
            } catch (IOException e) {
                throw new ApidocException(e);
            }
        }
        Iterator<String> iterator = projectSourcePaths.iterator();
        Set<String> copyPaths = new HashSet<>();
        while (iterator.hasNext()){
            String next = iterator.next();
            if(!next.endsWith(File.separator)){
                next += File.separator;
            }
            if(!next.endsWith(filePost)){
                next += filePost;
            }
            copyPaths.add(next);
        }
        projectSourcePaths = copyPaths;
        ProjectContext.projectBasePath = projectSourcePaths;
        ProjectContext.controllerOperator = new ReadControllerOperator(ProjectContext.allConfiguration.getReadControllerConfig());
        ProjectContext.interfaceOperator = new ReadInterfaceOperator(ProjectContext.allConfiguration.getReadInterfaceConfig());
        ProjectContext.beanOperator = new ReadBeanOperator(ProjectContext.allConfiguration.getReadBeanConfig());
        ProjectContext.mockTemplateOperator = new ReadMockTemplateOperator(ProjectContext.allConfiguration.getReadMockTemplateConfig());
        ProjectContext.requestOperator = new ReadRequestOperator(ProjectContext.allConfiguration.getReadRequestConfig());
        ProjectContext.responseOperator = new ReadResponseOperator(ProjectContext.allConfiguration.getReadResponseConfig());

        EasyApiBaseConfiguration base = all.getConfiguration();
        if(base.getGlobalResponseClass()!=null && !StringUtil.isEmpty(base.getGlobalResponseFieldName())){
            ProjectContext.globalFieldName = base.getGlobalResponseFieldName();
            ProjectContext.globalResponseIgnoreFieldNames = base.getGlobalResponseIgnoreFieldNames();
            Class<?> globalResponseClass = base.getGlobalResponseClass();
            ProjectContext.globalResponseClass = globalResponseClass;
            List<MethodParam> globalParams = new ArrayList<>();
            Field[] fields = globalResponseClass.getDeclaredFields();
            for (Field field : fields) {
                MethodParam param = new MethodParam();
                param.setParamType(field.getGenericType());
                param.setParamName(field.getName());
                globalParams.add(param);
            }
            ProjectContext.globalParams = globalParams;
        }
    }

    private static void initDataSource(AllConfiguration all){
        EasyApiBaseConfiguration configuration = all.getConfiguration();
        EasyApiDataConfiguration dataConfiguration = all.getDataConfiguration();
        //处理数据库
        if(StringUtil.isEmpty(dataConfiguration.getDriverClassName())){
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if(StringUtil.isEmpty(dataConfiguration.getUrl())){
            String dbFilePath = all.getDataConfiguration().getDbFilePath();
            if(dbFilePath.endsWith(File.separator)){
                dbFilePath = dbFilePath.substring(0,dbFilePath.length()-1);
            }
            dataConfiguration.setUrl("jdbc:h2:"+dbFilePath+"-easyapi;AUTO_SERVER=TRUE");
        }
        if(StringUtil.isEmpty(dataConfiguration.getUserName())){
            dataConfiguration.setUserName("easyapi");
        }
        if(StringUtil.isEmpty(dataConfiguration.getPassword())){
            dataConfiguration.setPassword("123456");
        }
        List<DBTables> mappersClasses = new ArrayList<>(Arrays.asList(DBTables.values()));
        mappersClasses.removeIf(table -> table.getMapper() == null);
        List<Class<?>> collect = mappersClasses.stream().map(DBTables::getMapper).collect(Collectors.toList());
        Class<?>[] mappers = new Class[collect.size()];
        collect.toArray(mappers);
        if(dataConfiguration.getDataSource() != null){
            //使用用户提供的连接池
            MybatisUtil.init(dataConfiguration.getDataSource(),mappers);
        }else{
            //创建连接池
            DataSource dataSource = dataSource(dataConfiguration.getUrl()
                    , dataConfiguration.getDriverClassName()
                    , dataConfiguration.getUserName()
                    , dataConfiguration.getPassword());
            MybatisUtil.init(dataSource, mappers);
        }
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        //如果配置了删除构建，则删除相关表
        if(configuration.isDropAll()){
            for (DBTables table : DBTables.values()) {
                mapper.execUpdate(table.dropSql());
            }
        }
        //重新初始化数据库表，如果不存在则创建
        for (DBTables table : DBTables.values()) {
            mapper.execUpdate(table.tableDDL());
            table.replenishField();
        }
        if(configuration.isDropUsers()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.user)) {
                mapper.execUpdate(table.clearSql());
            }
        }
        if(configuration.isDropGlobalSetting()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.global)) {
                mapper.execUpdate(table.clearSql());
            }
        }
        if(configuration.isDropDoc()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.doc)) {
                mapper.execUpdate(table.clearSql());
            }
        }
    }

    private static DataSource dataSource(String url,String driverClassName,String username, String password){
        // 连接数据库
//        String URL = "jdbc:h2:file:"+ProjectContext.dbPath+ProjectContext.dbFileName+"-"+projectName;
//        String USER = "easyapi";
//        String PASSWORD = "123456";

        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }
}
