/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util.http;

import cn.easyutil.easyapi.util.IOUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpBaseRequest;
import cn.easyutil.easyapi.util.http.HttpFileReq;
import cn.easyutil.easyapi.util.http.HttpMethod;
import cn.easyutil.easyapi.util.http.HttpOperation;
import cn.easyutil.easyapi.util.http.HttpReq;
import cn.easyutil.easyapi.util.http.HttpRes;
import cn.easyutil.easyapi.util.http.HttpUtilFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class HttpClientOperation
extends HttpOperation {
    public HttpClientOperation() {
    }

    public HttpClientOperation(HttpReq httpReq) {
        super(httpReq);
    }

    public HttpClientOperation(String url) {
        super(url);
    }

    public HttpClientOperation(String url, HttpMethod httpMethod) {
        super(url, httpMethod);
    }

    @Override
    protected HttpRes doUrl(boolean useSSL, HttpReq httpReq, InputStream certInput, char[] password) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        HttpEntity httpEntity = null;
        HttpBaseRequest request = null;
        try {
            if (useSSL) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(certInput, password);
                SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password).build();
                SSLConnectionSocketFactory httpRes = new SSLConnectionSocketFactory(sslcontext);
                httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)httpRes).build();
            }
            request = new HttpBaseRequest(httpReq.getMethod());
            request.setURI(URI.create(httpReq.getUrl()));
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.setCharset(Charset.forName(this.getCharset()));
            if (httpReq.getFileParams() != null && !httpReq.getFileParams().isEmpty()) {
                for (HttpFileReq httpFileReq : httpReq.getFileParams()) {
                    ContentType ct = ContentType.create((String)"application/octet-stream", (String)this.getCharset());
                    multipartEntityBuilder.addBinaryBody(httpFileReq.getParamName(), httpFileReq.getContent(), ct, httpFileReq.getFileName());
                }
            }
            if (httpReq.getParams().containsKey("_null")) {
                Object v;
                Object ct = ContentType.APPLICATION_JSON;
                if (httpReq.getHeader().containsKey("Content-Type")) {
                    ct = ContentType.create((String)httpReq.getHeader().get("Content-Type"), (String)this.getCharset());
                }
                httpEntity = new StringEntity(Optional.ofNullable(httpReq.getParams().get("_null")).orElse("").toString(), (ContentType)ct);
                if (httpReq.getMethod() == HttpMethod.GET && (v = httpReq.getParams().get("_null")) != null && !StringUtil.isEmpty(v.toString())) {
                    request.setURI(URI.create(httpReq.getUrl() + "?" + v.toString()));
                }
            } else {
                for (Object e : httpReq.getParams().keySet()) {
                    multipartEntityBuilder.addTextBody(e.toString(), httpReq.getParams().get(e).toString(), ContentType.APPLICATION_FORM_URLENCODED);
                }
                if (httpReq.getMethod() == HttpMethod.GET) {
                    String params = HttpClientOperation.jsonToForm(JsonUtil.beanToJson(httpReq.getParams()));
                    if (params != null && !StringUtil.isEmpty(params)) {
                        request.setURI(URI.create(httpReq.getUrl() + "?" + (String)params));
                    }
                } else {
                    httpEntity = multipartEntityBuilder.build();
                }
            }
            request.setEntity(httpEntity);
            if (!httpReq.getHeader().containsKey("User-Agent")) {
                request.addHeader("User-Agent", "easyapi");
            }
            for (Map.Entry entry : httpReq.getHeader().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                request.addHeader(key, value);
            }
            RequestConfig conf = RequestConfig.custom().setConnectTimeout(httpReq.getConnectTimeOut()).build();
            request.setConfig(conf);
            response = httpClient.execute((HttpUriRequest)request);
            HttpRes httpRes = this.processResponse(response);
            return httpRes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
                if (certInput != null) {
                    certInput.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private HttpRes processResponse(CloseableHttpResponse response) {
        HttpRes result = new HttpRes();
        HttpEntity entity = response.getEntity();
        Header[] allHeaders = response.getAllHeaders();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : allHeaders) {
            String name = header.getName();
            String value = header.getValue();
            headers.put(name, value);
        }
        result.setResponseHeaders(headers);
        try {
            result.setResponseCode(response.getStatusLine().getStatusCode());
            byte[] bytes = IOUtil.inputToByte(entity.getContent());
            result.setResponseInputStream(IOUtil.byteToInput(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        String url = "https://img.alicdn.com/imgextra/i2/O1CN012L5BFz1anL3YMTKhg_!!6000000003374-2-tps-2880-584.png";
        HttpOperation operation = HttpUtilFactory.fastCreate(url, "GET");
        operation.header("ContentType", "application/x-www-form-urlencoded");
        HttpRes res = operation.doUrl();
        System.out.println(res);
    }
}

