/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringUtil {
    public static String getRequestPath(Class clazz) {
        Annotation[] annotations = clazz.getAnnotations();
        return SpringUtil.getRequestPath(annotations);
    }

    public static String getRequestPath(Method method) {
        Annotation[] annotations = method.getAnnotations();
        return SpringUtil.getRequestPath(annotations);
    }

    public static String getRequestPath(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return "";
        }
        for (Annotation annotation : annotations) {
            if (!SpringUtil.isAssignableFromAnnotation(annotation, RequestMapping.class)) continue;
            String[] path = SpringUtil.getAnnotationValue(annotation, "path", String[].class);
            if (path != null && path.length > 0) {
                return path[0];
            }
            String name = SpringUtil.getAnnotationValue(annotation, "name", String.class);
            if (!StringUtil.isEmpty(name)) {
                return name;
            }
            String[] value = SpringUtil.getAnnotationValue(annotation, "value", String[].class);
            if (value == null || value.length <= 0) continue;
            return value[0];
        }
        return "";
    }

    public static <T> T getAnnotationValue(Annotation annotation, String key, Class<T> parse) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field field = invocationHandler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            Map memberValues = (Map)field.get(invocationHandler);
            if (memberValues == null || memberValues.isEmpty()) {
                return null;
            }
            field.setAccessible(false);
            return (T)memberValues.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Annotation getAssignableFromAnnotation(Annotation source, Class target) {
        ArrayList<Annotation> exsit = new ArrayList<Annotation>();
        SpringUtil.isAssignableFromAnnotation(source, target, exsit);
        if (exsit.size() > 0) {
            return (Annotation)exsit.get(0);
        }
        return null;
    }

    public static boolean isAssignableFromAnnotation(Annotation source, Class target) {
        ArrayList<Annotation> exsit = new ArrayList<Annotation>();
        SpringUtil.isAssignableFromAnnotation(source, target, exsit);
        return exsit.size() > 0;
    }

    private static void isAssignableFromAnnotation(Annotation source, Class target, List<Annotation> exsit) {
        Annotation[] ans;
        if (source instanceof Target || source instanceof Documented || source instanceof Retention) {
            return;
        }
        if (source.annotationType().isAssignableFrom(target)) {
            exsit.add(source);
        }
        if ((ans = source.annotationType().getAnnotations()) == null || ans.length == 0) {
            return;
        }
        for (Annotation an : ans) {
            SpringUtil.isAssignableFromAnnotation(an, target, exsit);
        }
    }

    public static RequestMethod getRequestMethod(Method method) {
        Annotation[] annotations = method.getAnnotations();
        RequestMethod requestMethod = RequestMethod.POST;
        for (Annotation annotation : annotations) {
            Annotation an = SpringUtil.getAssignableFromAnnotation(annotation, RequestMapping.class);
            if (an == null) continue;
            RequestMapping mapping = (RequestMapping)an;
            RequestMethod[] methods = mapping.method();
            if (methods == null || methods.length == 0) break;
            requestMethod = methods[0];
            break;
        }
        return requestMethod;
    }
}

