/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class JavaBeanCreator {
    public static final String nullKey = "_null";
    private ReadBeanOperator filter;
    private ReadMockTemplateOperator mockFilter;
    private String projectBasePath;
    private ApiExtra extra;

    public static JavaBeanCreator builder(ReadBeanOperator filter, String projectBasePath, ReadMockTemplateOperator mockFilter, ApiExtra extra) {
        JavaBeanCreator creator = new JavaBeanCreator(filter, projectBasePath, mockFilter, extra);
        return creator;
    }

    public JavaBeanCreator(ReadBeanOperator filter, String projectBasePath, ReadMockTemplateOperator mockFilter, ApiExtra extra) {
        this.filter = filter;
        this.projectBasePath = projectBasePath;
        this.mockFilter = mockFilter;
        this.extra = extra;
    }

    private String buildCreatersKey(Class aClass, GenericTypeBind bind) {
        String bindKey = "";
        if (bind.keys().size() > 0) {
            for (String key : bind.keys()) {
                bindKey = bindKey + bind.get(key);
            }
        }
        return aClass.getCanonicalName() + bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass == Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = this.buildCreatersKey(aClass, currentBinds);
        if (exists.containsKey(creatersKey)) {
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)), DocParamEntity.class);
        }
        exists.put(creatersKey, Collections.emptyList());
        ArrayList<DocParamEntity> bean = new ArrayList();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType) {
            case Object: {
                bean = this.getBean(aClass, binds, exists);
                break;
            }
            case ArrayObject: {
                bean = this.readArrayObject(type, binds, exists);
                break;
            }
            case Array: {
                bean = this.readArray(type, binds);
            }
        }
        exists.put(creatersKey, bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type, GenericTypeBind binds) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            arrayType = bindType != null ? bindType : genericTypeBind.get(0);
        }
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        RenewType renewType = this.filter.renewType(this.extra.getModelClass(), binds, this.extra);
        childrean.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setUnique(StringUtil.toMD5(this.extra.getModelField().toGenericString()));
        childrean.setClassName(type.getTypeName());
        childrean.setName(nullKey);
        Object mockValue = this.mockFilter.mock(childrean.getMockTemplate(), JavaType.getType(childrean.getJavaType()));
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
        childrean.setOrigin(EasyapiOriginUtil.createOrigin(childrean));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class<Map> arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type) && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = binds.get(0);
        }
        if (arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = Map.class;
        }
        return this.readBean((Type)((Object)arrayType), binds, exists);
    }

    private List<DocParamEntity> getBean(Class<?> beanClass, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        this.extra.setModelField(null);
        this.extra.setFieldComment(null);
        this.extra.setModelClass(null);
        this.extra.setModelComment(null);
        ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
        Class<?> clazz = beanClass;
        HashSet<String> fieldNames = new HashSet<String>();
        while (clazz != null && !clazz.equals(Object.class) && clazz != Class.class) {
            this.extra.setModelClass(clazz);
            JavaSourceReader classFileReader = JavaSourceReader.builder(CreatorCommonMethod.getClassFile(clazz, this.projectBasePath));
            this.extra.setModelComment(classFileReader.getComment());
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));
            List<FieldParam> params = this.filter.params(clazz, binds, this.extra);
            if (params == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            for (FieldParam param : params) {
                JavaType javaType;
                String description;
                Object bindType;
                this.extra.setModelClass(clazz);
                this.extra.setModelComment(classFileReader.getComment());
                this.extra.setModelField(null);
                this.extra.setFieldComment(null);
                Field field = param.getField();
                Class<Map> type = param.getParamType();
                String paramName = param.getParamName();
                this.extra.setModelField(field);
                if (StringUtil.isEmpty(paramName)) continue;
                if (field != null) {
                    this.extra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                }
                if (this.filter.ignore((Type)((Object)type), binds, this.extra).booleanValue()) continue;
                int size = fieldNames.size();
                fieldNames.add(paramName);
                if (size == fieldNames.size()) continue;
                Class<Map> ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                if (GenericTypeUtil.isGeneric((Type)((Object)type)) && !GenericTypeUtil.isArray((Type)((Object)type)) && (bindType = binds.matchVariable(type.getTypeName())) != null) {
                    type = bindType;
                    ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                }
                if (type == null || ownerClass == null) continue;
                bindType = currentBinds.keys().iterator();
                while (bindType.hasNext()) {
                    String key = (String)bindType.next();
                    Type matchType = binds.matchVariable(currentBinds.get(key).getTypeName());
                    if (matchType == null) continue;
                    currentBinds.bind(key, matchType);
                }
                if (currentBinds.size() == 0) {
                    currentBinds.binds(binds);
                }
                if (StringUtil.isEmpty(description = this.filter.description((Type)((Object)type), binds, this.extra))) {
                    description = paramName;
                }
                if (!(GenericTypeUtil.isArray((Type)((Object)type)) || ownerClass != Object.class && ownerClass != Class.class)) {
                    ownerClass = Map.class;
                    type = Map.class;
                }
                if ((javaType = this.filter.javaType((Type)((Object)type), binds, this.extra)) == null) continue;
                DocParamEntity entity = new DocParamEntity();
                entity.setName(paramName);
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(this.filter.mockTemplate((Type)((Object)type), binds, this.extra));
                entity.setShow(this.filter.show((Type)((Object)type), binds, this.extra) != false ? 1 : 0);
                entity.setRequired(this.filter.required((Type)((Object)type), binds, this.extra) != false ? 1 : 0);
                entity.setConditionTemplate(String.join((CharSequence)",", this.filter.conditions((Type)((Object)type), binds, this.extra)));
                switch (javaType) {
                    case Object: 
                    case ArrayObject: 
                    case Array: {
                        entity.setChildren(this.readBean((Type)((Object)type), currentBinds, exists));
                        break;
                    }
                    default: {
                        Object mockValue = this.mockFilter.mock(entity.getMockTemplate(), javaType);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
                    }
                }
                entity.setUnique(field == null ? UUID.randomUUID().toString() : StringUtil.toMD5(field.toGenericString()));
                RenewType renewType = this.filter.renewType((Type)((Object)type), binds, this.extra);
                entity.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
                entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
                result.add(entity);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }
}

