/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.html;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.service.ArticleService;
import cn.easyutil.easyapi.service.ControllerService;
import cn.easyutil.easyapi.service.InterfaceParamService;
import cn.easyutil.easyapi.service.InterfaceService;
import cn.easyutil.easyapi.service.OutPackageService;
import cn.easyutil.easyapi.service.ProjectService;
import cn.easyutil.easyapi.service.SimpleUnitService;
import cn.easyutil.easyapi.service.UserService;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ZipUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
public class StaticDocCreate {
    @Resource(name="easyapiUserService")
    private UserService userService;
    @Resource(name="easyapiControllerService")
    private ControllerService controllerService;
    @Resource(name="easyapiInterfaceService")
    private InterfaceService interfaceService;
    @Resource(name="easyapiInterfaceParamService")
    private InterfaceParamService paramService;
    @Resource(name="easyapiSimpleUnitService")
    private SimpleUnitService unitService;
    @Resource(name="easyapiProjectService")
    private ProjectService projectService;
    @Resource(name="easyapiOutPackageService")
    private OutPackageService outPackageService;
    @Resource(name="easyapiArticleService")
    private ArticleService articleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(HttpServletResponse response) throws UnsupportedEncodingException {
        String basePath = ProjectContext.currentProjectName + "-static-api";
        File zipFile = new File(basePath + "-api.zip");
        File root = null;
        if (!zipFile.exists()) {
            StaticDocCreate staticDocCreate = this;
            synchronized (staticDocCreate) {
                if (!zipFile.exists()) {
                    root = this.createApiFolder(basePath);
                    this.toZip(basePath, zipFile);
                }
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(ProjectContext.currentProjectName + "-apidoc.zip", "utf-8"));
        try (FileInputStream in = new FileInputStream(zipFile);){
            byte[] but = new byte[0x100000];
            int length = 0;
            while ((length = in.read(but)) != -1) {
                response.getOutputStream().write(but, 0, length);
                response.getOutputStream().flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deepDelFile(zipFile);
        if (root != null) {
            this.deepDelFile(root);
        }
    }

    private void deepDelFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                file.delete();
            } else {
                Stream.of(files).forEach(this::deepDelFile);
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private File createApiFolder(String basePath) {
        File root = new File(basePath);
        root.delete();
        root.mkdirs();
        this.createBaseFiles(basePath);
        try {
            this.createStaticData(basePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    private void createBaseFiles(String basePath) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        this.saveFile(basePath, resourceLoader.getResource("classpath:static/apidoc.html"));
        this.saveFile(basePath, resourceLoader.getResource("classpath:static/logo.png"));
        String cssPath = basePath + File.separator + "css";
        new File(cssPath).mkdirs();
        this.saveFile(cssPath, resourceLoader.getResource("classpath:static/css/app.4ec4a50b.css"));
        this.saveFile(cssPath, resourceLoader.getResource("classpath:static/css/chunk-247fba11.86fc53a9.css"));
        this.saveFile(cssPath, resourceLoader.getResource("classpath:static/css/chunk-2772a9e5.7f1df6f0.css"));
        this.saveFile(cssPath, resourceLoader.getResource("classpath:static/css/chunk-54665d78.5fe7e4ca.css"));
        this.saveFile(cssPath, resourceLoader.getResource("classpath:static/css/chunk-vendors.7e47431c.css"));
        String fontPath = basePath + File.separator + "fonts";
        new File(fontPath).mkdirs();
        this.saveFile(fontPath, resourceLoader.getResource("classpath:static/fonts/element-icons.535877f5.woff"));
        this.saveFile(fontPath, resourceLoader.getResource("classpath:static/fonts/element-icons.732389de.ttf"));
        this.saveFile(fontPath, resourceLoader.getResource("classpath:static/fonts/iconfont.f40bf2ee.ttf"));
        String imgPath = basePath + File.separator + "img";
        new File(imgPath).mkdirs();
        this.saveFile(imgPath, resourceLoader.getResource("classpath:static/img/favicon.49b31d60.png"));
        this.saveFile(imgPath, resourceLoader.getResource("classpath:static/img/logo.8c9f1ac1.png"));
        String jsPath = basePath + File.separator + "js";
        new File(jsPath).mkdirs();
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/app.421693a8.js"));
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/chunk-247fba11.54096b3d.js"));
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/chunk-2772a9e5.a4487d13.js"));
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/chunk-13703fdd.30aa4d5a.js"));
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/chunk-54665d78.4a1802c9.js"));
        this.saveFile(jsPath, resourceLoader.getResource("classpath:static/js/chunk-vendors.b6174eff.js"));
    }

    private void createStaticData(String basePath) throws Exception {
        File dataFile = new File(basePath + File.separator + "StaticData.js");
        List<DBUserEntity> users = this.userService.list(new DBUserEntity());
        List controllers = this.controllerService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(DBModuleControllerEntity::getShow, (Object)1, new Boolean[0]));
        ArrayList<FindControllerAndInterfaceVo> controllerVos = new ArrayList<FindControllerAndInterfaceVo>();
        if (controllers != null && !controllers.isEmpty()) {
            for (DBModuleControllerEntity controller : controllers) {
                FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
                BeanUtils.copyProperties((Object)controller, (Object)vo);
                DBModuleInterfaceEntity queryIn = new DBModuleInterfaceEntity();
                queryIn.setControllerId(controller.getId());
                vo.setChildren(Optional.ofNullable(this.interfaceService.list(EasyapiBindSQLExecuter.build(queryIn).eq(DBModuleControllerEntity::getShow, (Object)1, new Boolean[0]))).orElse(Collections.emptyList()));
                controllerVos.add(vo);
            }
        }
        List interfaces = this.interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).eq(DBModuleControllerEntity::getShow, (Object)1, new Boolean[0]));
        List<DBInterfaceParamEntity> params = this.paramService.list(new DBInterfaceParamEntity());
        List<DBSimpleUnitEntity> units = this.unitService.list(new DBSimpleUnitEntity());
        List<DBModuleOutPackageEntity> packages = this.outPackageService.list(new DBModuleOutPackageEntity());
        List<DBArticleEntity> articles = this.articleService.list(new DBArticleEntity());
        DBProjectEntity project = this.projectService.get(new DBProjectEntity());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile)));
        writer.write("var ApiProfile = {");
        writer.newLine();
        writer.write("isStatic: true,");
        writer.newLine();
        writer.write("project: " + JsonUtil.beanToJson(project) + ",");
        writer.newLine();
        writer.write("userList: " + JsonUtil.beanToJson(users) + ",");
        writer.newLine();
        writer.write("controllerList: " + JsonUtil.beanToJson(controllerVos) + ",");
        writer.newLine();
        writer.write("interfaceList: " + JsonUtil.beanToJson(interfaces) + ",");
        writer.newLine();
        writer.write("paramList: " + JsonUtil.beanToJson(params) + ",");
        writer.newLine();
        writer.write("unitList: " + JsonUtil.beanToJson(units) + ",");
        writer.newLine();
        writer.write("paramPackages: " + JsonUtil.beanToJson(packages) + ",");
        writer.newLine();
        writer.write("articles: " + JsonUtil.beanToJson(articles) + ",");
        writer.newLine();
        writer.write("}");
        writer.flush();
        writer.close();
    }

    private void saveFile(String basePath, org.springframework.core.io.Resource resource) {
        String filename = basePath + File.separator + resource.getFilename();
        try (InputStream inputStream = resource.getInputStream();){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(new File(filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void toZip(String folderPath, File zipFile) {
        try (FileOutputStream fos1 = new FileOutputStream(zipFile);){
            ZipUtil.toZip(folderPath, fos1, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

