/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadInterfaceConfig;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceBodyType;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceCustomSearch;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceDescription;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceEnableReqPackage;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceEnableResPackage;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceIgnore;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceRenewType;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceRequestMethod;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceRequestUrl;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceShow;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceShowName;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceUnique;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceVerifyMockTag;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaces;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.web.bind.annotation.RequestMethod;

public class ReadInterfaceOperator
implements ReadInterfaceBodyType,
ReadInterfaceCustomSearch,
ReadInterfaceDescription,
ReadInterfaceEnableReqPackage,
ReadInterfaceEnableResPackage,
ReadInterfaceIgnore,
ReadInterfaceRenewType,
ReadInterfaceRequestUrl,
ReadInterfaceRequestMethod,
ReadInterfaces,
ReadInterfaceShow,
ReadInterfaceShowName,
ReadInterfaceUnique,
ReadInterfaceVerifyMockTag {
    private final ReadInterfaceConfig config;

    public ReadInterfaceOperator(ReadInterfaceConfig config) {
        if (config == null) {
            config = new ReadInterfaceConfig();
        }
        this.config = config;
        this.addDefault();
    }

    private void addDefault() {
        this.config.getReadBodyTypes().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceBodyType.class));
        this.config.getReadCustomSearch().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceCustomSearch.class));
        this.config.getReadDescription().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceDescription.class));
        this.config.getReadIgnore().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceIgnore.class));
        this.config.getReadInterfaces().addAll(DefaultReaderEnum.getDefaults(ReadInterfaces.class));
        this.config.getReadRenewTypes().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRenewType.class));
        this.config.getReadReqPackages().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceEnableReqPackage.class));
        this.config.getReadResPackages().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceEnableResPackage.class));
        this.config.getReadRequestMethods().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRequestMethod.class));
        this.config.getReadRequestUrls().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRequestUrl.class));
        this.config.getReadShowNames().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceShowName.class));
        this.config.getReadShows().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceShow.class));
        this.config.getReadUniques().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceUnique.class));
        this.config.getReadVerifyMockTags().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceVerifyMockTag.class));
    }

    @Override
    public BodyType bodyType(Method method, ApiExtra extra) {
        for (ReadInterfaceBodyType readBodyType : this.config.getReadBodyTypes()) {
            BodyType bodyType = readBodyType.bodyType(method, extra);
            if (bodyType == null) continue;
            return bodyType;
        }
        return BodyType.FORM;
    }

    @Override
    public List<String> customSearch(Method method, ApiExtra extra) {
        for (ReadInterfaceCustomSearch readCustomSearch : this.config.getReadCustomSearch()) {
            List<String> list = readCustomSearch.customSearch(method, extra);
            if (list == null || list.isEmpty()) continue;
            return list;
        }
        return new ArrayList<String>();
    }

    @Override
    public String description(Method method, ApiExtra extra) {
        for (ReadInterfaceDescription readInterfaceDescription : this.config.getReadDescription()) {
            String description = readInterfaceDescription.description(method, extra);
            if (StringUtil.isEmpty(description)) continue;
            return description;
        }
        return "";
    }

    @Override
    public Boolean enableReqPackage(Method method, ApiExtra extra) {
        for (ReadInterfaceEnableReqPackage readReqPackage : this.config.getReadReqPackages()) {
            Boolean toPackage = readReqPackage.enableReqPackage(method, extra);
            if (toPackage == null) continue;
            return toPackage;
        }
        return false;
    }

    @Override
    public Boolean enableResPackage(Method method, ApiExtra extra) {
        for (ReadInterfaceEnableResPackage readResPackage : this.config.getReadResPackages()) {
            Boolean toPackage = readResPackage.enableResPackage(method, extra);
            if (toPackage == null) continue;
            return toPackage;
        }
        return false;
    }

    @Override
    public Boolean ignore(Method method, ApiExtra extra) {
        for (ReadInterfaceIgnore readInterfaceIgnore : this.config.getReadIgnore()) {
            Boolean ignore = readInterfaceIgnore.ignore(method, extra);
            if (ignore == null) continue;
            return ignore;
        }
        return false;
    }

    @Override
    public RenewType renewType(Method method, ApiExtra extra) {
        for (ReadInterfaceRenewType readRenewType : this.config.getReadRenewTypes()) {
            RenewType renewType = readRenewType.renewType(method, extra);
            if (renewType == null) continue;
            return renewType;
        }
        return RenewType.increment;
    }

    @Override
    public RequestMethod requestMethod(Method method, ApiExtra extra) {
        for (ReadInterfaceRequestMethod readRequestMethod : this.config.getReadRequestMethods()) {
            RequestMethod requestMethod = readRequestMethod.requestMethod(method, extra);
            if (requestMethod == null) continue;
            return requestMethod;
        }
        return RequestMethod.POST;
    }

    @Override
    public String requestUrl(Method method, ApiExtra extra) {
        for (ReadInterfaceRequestUrl readRequestUrl : this.config.getReadRequestUrls()) {
            String requestUrl = readRequestUrl.requestUrl(method, extra);
            if (StringUtil.isEmpty(requestUrl)) continue;
            return requestUrl;
        }
        return "";
    }

    @Override
    public Boolean show(Method method, ApiExtra extra) {
        for (ReadInterfaceShow readShow : this.config.getReadShows()) {
            Boolean show = readShow.show(method, extra);
            if (show == null) continue;
            return show;
        }
        return true;
    }

    @Override
    public String showName(Method method, ApiExtra extra) {
        for (ReadInterfaceShowName readShowName : this.config.getReadShowNames()) {
            String name = readShowName.showName(method, extra);
            if (StringUtil.isEmpty(name)) continue;
            return name;
        }
        return "";
    }

    @Override
    public String unique(Method method, ApiExtra extra) {
        for (ReadInterfaceUnique readUnique : this.config.getReadUniques()) {
            String unique = readUnique.unique(method, extra);
            if (StringUtil.isEmpty(unique)) continue;
            return unique;
        }
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public Boolean verifyMockTag(String tag, DBModuleInterfaceEntity entity) {
        for (ReadInterfaceVerifyMockTag readVerifyMockTag : this.config.getReadVerifyMockTags()) {
            Boolean verifyMockTag = readVerifyMockTag.verifyMockTag(tag, entity);
            if (verifyMockTag == null) continue;
            return verifyMockTag;
        }
        return true;
    }

    @Override
    public List<Method> readAllInterfaces(Class controller, ApiExtra extra) {
        for (ReadInterfaces readInterface : this.config.getReadInterfaces()) {
            List<Method> methods = readInterface.readAllInterfaces(controller, extra);
            if (methods == null || methods.size() <= 0) continue;
            return methods;
        }
        return new ArrayList<Method>();
    }
}

