/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadControllerConfig;
import cn.easyutil.easyapi.filter.readController.ReadControllerAuthor;
import cn.easyutil.easyapi.filter.readController.ReadControllerDescription;
import cn.easyutil.easyapi.filter.readController.ReadControllerIgnore;
import cn.easyutil.easyapi.filter.readController.ReadControllerRequestPath;
import cn.easyutil.easyapi.filter.readController.ReadControllerShow;
import cn.easyutil.easyapi.filter.readController.ReadControllerShowName;
import cn.easyutil.easyapi.filter.readController.ReadControllers;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;

public class ReadControllerOperator
implements ReadControllerAuthor,
ReadControllerDescription,
ReadControllerIgnore,
ReadControllerRequestPath,
ReadControllers,
ReadControllerShow,
ReadControllerShowName {
    private final ReadControllerConfig config;

    public ReadControllerOperator(ReadControllerConfig config) {
        if (config == null) {
            config = new ReadControllerConfig();
        }
        this.config = config;
        this.addDefault();
    }

    private void addDefault() {
        this.config.getReadAuthors().addAll(DefaultReaderEnum.getDefaults(ReadControllerAuthor.class));
        this.config.getReadControllers().addAll(DefaultReaderEnum.getDefaults(ReadControllers.class));
        this.config.getReadDescriptions().addAll(DefaultReaderEnum.getDefaults(ReadControllerDescription.class));
        this.config.getReadIgnores().addAll(DefaultReaderEnum.getDefaults(ReadControllerIgnore.class));
        this.config.getReadRequestPaths().addAll(DefaultReaderEnum.getDefaults(ReadControllerRequestPath.class));
        this.config.getReadShowNames().addAll(DefaultReaderEnum.getDefaults(ReadControllerShowName.class));
        this.config.getReadShows().addAll(DefaultReaderEnum.getDefaults(ReadControllerShow.class));
    }

    @Override
    public String author(Class controller, ApiExtra extra) {
        for (ReadControllerAuthor readAuthor : this.config.getReadAuthors()) {
            String author = readAuthor.author(controller, extra);
            if (StringUtil.isEmpty(author)) continue;
            return author;
        }
        return "";
    }

    @Override
    public String description(Class controller, ApiExtra extra) {
        for (ReadControllerDescription readDescription : this.config.getReadDescriptions()) {
            String description = readDescription.description(controller, extra);
            if (StringUtil.isEmpty(description)) continue;
            return description;
        }
        return "";
    }

    @Override
    public Boolean ignore(Class controller, ApiExtra extra) {
        for (ReadControllerIgnore readIgnore : this.config.getReadIgnores()) {
            Boolean ignore = readIgnore.ignore(controller, extra);
            if (ignore == null) continue;
            return ignore;
        }
        return controller.getCanonicalName().startsWith("org.springframework");
    }

    @Override
    public String requestPath(Class controller, ApiExtra extra) {
        for (ReadControllerRequestPath readRequestPath : this.config.getReadRequestPaths()) {
            String requestPath = readRequestPath.requestPath(controller, extra);
            if (StringUtil.isEmpty(requestPath)) continue;
            return requestPath;
        }
        String mapping = SpringUtil.getRequestPath(controller);
        if (StringUtil.isEmpty(mapping)) {
            return "";
        }
        return this.parseUrl(mapping);
    }

    @Override
    public Boolean show(Class controller, ApiExtra extra) {
        for (ReadControllerShow readShow : this.config.getReadShows()) {
            Boolean show = readShow.show(controller, extra);
            if (show == null) continue;
            return show;
        }
        return false;
    }

    @Override
    public String showName(Class controller, ApiExtra extra) {
        for (ReadControllerShowName readShowName : this.config.getReadShowNames()) {
            String showName = readShowName.showName(controller, extra);
            if (StringUtil.isEmpty(showName)) continue;
            return showName;
        }
        return "";
    }

    @Override
    public Set<Class> readControllers(ApplicationContext springContext) {
        for (ReadControllers readController : this.config.getReadControllers()) {
            Set<Class> controllers = readController.readControllers(springContext);
            if (controllers == null) continue;
            return controllers;
        }
        Map beansWithAnnotation = springContext.getBeansWithAnnotation(Controller.class);
        HashSet<Class> set = new HashSet<Class>();
        for (Map.Entry next : beansWithAnnotation.entrySet()) {
            Object value = next.getValue();
            Class<?> aClass = value.getClass();
            if (aClass.getCanonicalName().contains("cn.easyutil.easyapi")) continue;
            if (aClass.getCanonicalName().contains("$$")) {
                set.add(aClass.getSuperclass());
                continue;
            }
            set.add(aClass);
        }
        return set;
    }

    private String parseUrl(String requestUrl) {
        if (StringUtil.isEmpty(requestUrl)) {
            return null;
        }
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}

