/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.doc.DBParamEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum DBTables {
    project("EASYAPI_PROJECT", DBTableClassify.global, DBProjectEntity.class),
    roleAuth("EASYAPI_ROLE_AUTH", DBTableClassify.global, DBRoleAuthEntity.class),
    role("EASYAPI_ROLE", DBTableClassify.global, DBRoleEntity.class),
    roleProject("EASYAPI_ROLE_PROJECTS", DBTableClassify.global, DBRoleProjectEntity.class),
    user("EASYAPI_USER", DBTableClassify.user, DBUserEntity.class),
    simpleUnit("EASYAPI_SIMPLE_UNIT", DBTableClassify.user, DBSimpleUnitEntity.class),
    complexTest("EASYAPI_COMPLEX_TEST", DBTableClassify.user, DBComplexTestEntity.class),
    complexTestGroup("EASYAPI_COMPLEX_TEST_GROUP", DBTableClassify.user, DBComplexTestGroupEntity.class),
    complexTestInfo("EASYAPI_COMPLEX_TEST_INFO", DBTableClassify.user, DBComplexTestInfoEntity.class),
    interfaceParam("EASYAPI_INTERFACE_PARAM", DBTableClassify.doc, DBInterfaceParamEntity.class),
    controllers("EASYAPI_MODULE_CONTROLLER", DBTableClassify.doc, DBModuleControllerEntity.class),
    module("EASYAPI_MODULE", DBTableClassify.global, DBModuleEntity.class),
    host("EASYAPI_MODULE_HOST", DBTableClassify.global, DBModuleHostEntity.class),
    interfaces("EASYAPI_MODULE_INTERFACE", DBTableClassify.doc, DBModuleInterfaceEntity.class),
    outPackage("EASYAPI_MODULE_OUT_PACKAGE", DBTableClassify.user, DBModuleOutPackageEntity.class),
    env("EASYAPI_MODULE_ENV", DBTableClassify.user, DBMouduleEnvEntity.class),
    header("EASYAPI_MODULE_HEADER", DBTableClassify.user, DBModuleHeaderEntity.class),
    script("EASYAPI_MODULE_SCRIPT", DBTableClassify.user, DBModuleScriptEntity.class),
    param("EASYAPI_PARAM", DBTableClassify.doc, DBParamEntity.class),
    userTemporaryAuth("EASYAPI_USER_TEMPORARY_AUTH", DBTableClassify.user, DBUserTemporaryAuthEntity.class),
    article("EASYAPI_ARTICLE", DBTableClassify.global, DBArticleEntity.class);

    private String tableName;
    private DBTableClassify classify;
    private Class<? extends BaseDbEntity> clazz;

    private DBTables(String tableName, DBTableClassify classify, Class<? extends BaseDbEntity> clazz) {
        this.tableName = tableName;
        this.classify = classify;
        this.clazz = clazz;
    }

    public String dropSql() {
        return "DROP TABLE IF EXISTS " + this.tableName + ";";
    }

    public String clearSql() {
        return "TRUNCATE table " + this.tableName + ";";
    }

    public String tableDDL() {
        Class<? extends BaseDbEntity> clazz = this.clazz;
        List<Tfd> tfds = this.getAllFields(clazz);
        if (tfds.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE if not exists ").append("`").append(this.tableName).append("`");
        sb.append("(").append("\n");
        for (Tfd tfd : tfds) {
            sb.append("\n");
            sb.append(tfd.ddl()).append(",");
        }
        sb.append("\n").append("PRIMARY KEY (`ID`)").append("\n");
        sb.append(")");
        return sb.toString();
    }

    public void replenishField(EasyapiBindSqlExecution execution) {
        List<Map<String, Object>> query = execution.query("SHOW COLUMNS FROM " + this.tableName);
        Set<Object> tableFields = new HashSet();
        if (query != null) {
            tableFields = query.stream().map(m -> m.get("FIELD").toString()).collect(Collectors.toSet());
        }
        List<Tfd> allFields = this.getAllFields(this.clazz);
        for (Tfd tfd : allFields) {
            String name = StringUtil.isEmpty(tfd.value()) ? tfd.name() : tfd.value();
            if (tableFields.contains(name)) continue;
            execution.update("ALTER TABLE " + this.tableName + " ADD " + tfd.ddl());
        }
    }

    public List<Tfd> getAllFields(Class<? extends BaseDbEntity> clazz) {
        ArrayList<Tfd> tfds = new ArrayList<Tfd>();
        Class<? extends BaseDbEntity> cl = clazz;
        while (!cl.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                Tfd tfd = field.getDeclaredAnnotation(Tfd.class);
                if (tfd == null) continue;
                tfds.add(tfd);
            }
            cl = cl.getSuperclass();
        }
        return tfds;
    }

    public static List<DBTables> getByClassify(DBTableClassify classify) {
        ArrayList<DBTables> result = new ArrayList<DBTables>();
        for (DBTables value : DBTables.values()) {
            if (value.classify != classify) continue;
            result.add(value);
        }
        return result;
    }
}

