/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterBeanConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterConfiguration;
import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.DBTables;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;

public class DocCreatePre {
    private AllConfiguration all;
    private ApplicationContext appContext;
    private EasyapiBindSqlExecution execution;

    public static DocCreatePre build(AllConfiguration all, ApplicationContext appContext) {
        DocCreatePre pre = new DocCreatePre();
        pre.all = all;
        pre.appContext = appContext;
        return pre;
    }

    public void pre() {
        this.initBase();
        this.initDataSource();
        this.showLogo();
        this.initProject();
        this.getRomoteBannerAndDoc();
    }

    private void getRomoteBannerAndDoc() {
        this.addDefaultArticles();
    }

    private void addDefaultArticles() {
        ArrayList<DBArticleEntity> articles = new ArrayList<DBArticleEntity>();
        DBArticleEntity a1 = new DBArticleEntity();
        a1.setTitle("\u6b22\u8fce\u4f7f\u7528easyapi");
        a1.setContent("\u5c0f\u660e\uff0c\u8d77\u6765\u81f4\u6b22\u8fce\u8f9e");
        articles.add(a1);
        DBArticleEntity a2 = new DBArticleEntity();
        a2.setTitle("\u5982\u4f55\u4f7f\u7528\u81ea\u5b9a\u4e49\u53d8\u91cf");
        a2.setContent("\u5728\u4efb\u610f\u8f93\u5165\u6846\u4e2d\u586b\u5199 {{\u53d8\u91cf\u540d}} \u5373\u53ef");
        articles.add(a2);
        DBArticleEntity a3 = new DBArticleEntity();
        a3.setTitle("\u5982\u4f55\u5207\u6362\u8bf7\u6c42\u73af\u5883");
        a3.setContent("\u5728\u9876\u90e8\u8bbe\u7f6e\u91cc\u9762\u6709\u8bf7\u6c42\u73af\u5883\u8bbe\u7f6e\uff0c\u53ef\u4ee5\u589e\u5220\u73af\u5883\uff0c\u540c\u65f6\u5728\u63a5\u53e3\u6a21\u62df\u8bf7\u6c42\u9875\u9762\u9009\u62e9\u73af\u5883");
        articles.add(a3);
        this.execution.insert(articles);
    }

    private void initProject() {
        DBRoleEntity defaultRole;
        DBUserEntity admin;
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project = this.execution.selectOne(project);
        DBModuleEntity module = (DBModuleEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(DBModuleEntity::getDefaultStatus, (Object)1, new Boolean[0]));
        if (project == null) {
            project = this.addDefaultProject();
        }
        if (module == null) {
            module = this.addDefaultModule(project);
        }
        if ((admin = (DBUserEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBUserEntity()).eq(DBUserEntity::getAccount, (Object)"admin", new Boolean[0]))) == null) {
            this.addDefaultUsers(module);
        }
        if ((defaultRole = (DBRoleEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBRoleEntity()).eq(DBRoleEntity::getDefaultRole, (Object)1, new Boolean[0]))) == null) {
            defaultRole = new DBRoleEntity();
            defaultRole.setDefaultRole(1);
            defaultRole.setSuperAdminStatus(0);
            defaultRole.setRoleName("\u9ed8\u8ba4\u89d2\u8272");
            this.execution.insert(defaultRole);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getName();
        ProjectContext.currentModuleName = module.getName();
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    private void initDataSource() {
        EasyapiConfiguration configuration = this.all.getConfiguration();
        EasyapiDataConfiguration dataConfiguration = this.all.getDataConfiguration();
        this.execution = ProjectContext.execution = new EasyapiBindSqlExecution();
        if (StringUtil.isEmpty(dataConfiguration.getDriverClassName())) {
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUrl())) {
            dataConfiguration.setUrl("jdbc:h2:file:" + ProjectContext.dbPath + ProjectContext.dbFileName + "-" + configuration.getTitle());
        }
        if (StringUtil.isEmpty(dataConfiguration.getUserName())) {
            dataConfiguration.setUserName("easyapi");
        }
        if (StringUtil.isEmpty(dataConfiguration.getPassword())) {
            dataConfiguration.setPassword("123456");
        }
        if (dataConfiguration.getDataSource() != null) {
            ProjectContext.execution.setDataSource(dataConfiguration.getDataSource());
        } else {
            DataSource dataSource = DocCreatePre.dataSource(dataConfiguration.getUrl(), dataConfiguration.getDriverClassName(), dataConfiguration.getUserName(), dataConfiguration.getPassword());
            ProjectContext.execution.setDataSource(dataSource);
        }
        if (configuration.isDropAll()) {
            for (DBTables table : DBTables.values()) {
                ProjectContext.execution.update(table.dropSql());
            }
        }
        for (DBTables table : DBTables.values()) {
            ProjectContext.execution.update(table.tableDDL());
            table.replenishField(ProjectContext.execution);
        }
        if (configuration.isDropUsers()) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.user)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
        if (configuration.isDropGlobalSetting()) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.global)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
        if (configuration.isDropDoc()) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.doc)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
    }

    private static DataSource dataSource(String url, String driverClassName, String username, String password) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000L);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000L);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }

    private void initBase() {
        EasyapiFilterBeanConfiguration beans = this.all.getFilterBeanConfiguration();
        EasyapiFilterConfiguration classes = this.all.getFilterClassConfiguration();
        if (beans == null) {
            beans = new EasyapiFilterBeanConfiguration();
            this.all.setFilterBeanConfiguration(beans);
        }
        if (beans.getReadControllerApiFilter() == null) {
            beans.setReadControllerApiFilter(this.newInstance(classes.getReadControllerApiFilter()));
        }
        if (beans.getReadBeanApiFilter() == null) {
            beans.setReadBeanApiFilter(this.newInstance(classes.getReadBeanApiFilter()));
        }
        if (beans.getReadInterfaceApiFilter() == null) {
            beans.setReadInterfaceApiFilter(this.newInstance(classes.getReadInterfaceApiFilter()));
        }
        if (beans.getReadRequestParamApiFilter() == null) {
            beans.setReadRequestParamApiFilter(this.newInstance(classes.getReadRequestParamApiFilter()));
        }
        if (beans.getReadResponseParamApiFilter() == null) {
            beans.setReadResponseParamApiFilter(this.newInstance(classes.getReadResponseParamApiFilter()));
        }
        if (beans.getReadMockTemplateFilter() == null) {
            beans.setReadMockTemplateFilter(this.newInstance(classes.getReadMockTemplateFilter()));
        }
        ProjectContext.allConfiguration = this.all;
        String projectSourcePath = this.all.getConfiguration().getProjectSourcePath();
        if (StringUtil.isEmpty(projectSourcePath)) {
            try {
                projectSourcePath = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                throw new ApidocException(e);
            }
        }
        ProjectContext.projectBasePath = projectSourcePath + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        if (!new File(projectSourcePath).exists()) {
            throw new ApidocException("\u9879\u76ee\u8def\u5f84\uff1a" + projectSourcePath + "\u9519\u8bef");
        }
    }

    private void showLogo() {
        String text = "                                        _\n                                       (_)\n  ___  __ _ ___ _   _ ______ __ _ _ __  _\n / _ \\/ _` / __| | | |______/ _` | '_ \\| |\n|  __/ (_| \\__ \\ |_| |     | (_| | |_) | |\n \\___|\\__,_|___/\\__, |      \\__,_| .__/|_|\n                 __/ |           | |\n                |___/            |_|\n    -------------------------------\u63a5\u53e3\u6587\u6863\n    ---http://localhost:\u9879\u76ee\u7aef\u53e3/apidoc.html";
        System.out.println(text);
    }

    private DBModuleEntity addDefaultModule(DBProjectEntity project) {
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("\u9ed8\u8ba4\u6a21\u5757");
        module.setDescription("\u521d\u59cb\u5316\u9879\u76ee\u6a21\u5757");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(1);
        this.execution.insert(module);
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock\u8bf7\u6c42,\u8fd4\u56demock\u7ed3\u679c");
        mock.setDefaultStatus(1);
        mock.setDisable(0);
        mock.setCanDelete(0);
        String port = this.appContext.getEnvironment().getProperty("server.port");
        port = port == null ? "8080" : port;
        mock.setHost("mock");
        this.execution.insert(mock);
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("\u672c\u5730\u73af\u5883");
        local.setDescription("\u672c\u673a\u73af\u5883");
        local.setDefaultStatus(0);
        local.setDisable(0);
        mock.setCanDelete(1);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        local.setHost("http://" + address + ":" + port);
        this.execution.insert(local);
        return module;
    }

    private DBProjectEntity addDefaultProject() {
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project.setTitle(this.all.getConfiguration().getTitle());
        project.setName(this.all.getConfiguration().getTitle());
        project.setDescription(ProjectContext.allConfiguration.getConfiguration().getDescription());
        this.execution.insert(project);
        return project;
    }

    private void addDefaultUsers(DBModuleEntity module) {
        List<Integer> codes = AuthMoudle.allCode();
        DBUserEntity user = new DBUserEntity();
        user.setAccount(this.all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(this.all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setNickName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setHidden(1);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(user);
        for (Integer code : codes) {
            DBUserTemporaryAuthEntity ua = new DBUserTemporaryAuthEntity();
            ua.setUserId(user.getId());
            ua.setAuthCode(code);
            this.execution.insert(ua);
        }
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setHidden(1);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(hiddenUser);
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("\u6d4b\u8bd5\u4eba\u5458");
        testRole.setDescription("\u4ec5\u63d0\u4f9b\u6d4b\u8bd5\u76f8\u5173\u7684\u6743\u9650");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(testRole);
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(roleProject);
        List<Integer> defaultAuthCodes = AuthMoudle.getDefaultAuthCodes();
        ArrayList<DBRoleAuthEntity> auths = new ArrayList<DBRoleAuthEntity>();
        ArrayList uauths = new ArrayList();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        this.execution.insert(auths);
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("\u6d4b\u8bd5\u8d26\u53f7");
        test.setDescription("\u6d4b\u8bd5\u4eba\u5458\u8d26\u53f7");
        test.setDisable(0);
        this.execution.insert(test);
    }
}

