/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterBeanConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiSyncRemoteConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUnitConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUserConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBParamEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.model.DefaultReadControllerApi;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.ControllerCreator;
import cn.easyutil.easyapi.logic.creator.InterfaceCreator;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParamsCreator;
import cn.easyutil.easyapi.logic.run.DocClassBean;
import cn.easyutil.easyapi.logic.run.DocInterfaceBean;
import cn.easyutil.easyapi.test.TestController;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

public class DocCreate {
    private AllConfiguration all;
    private ApplicationContext appContext;
    private EasyapiBindSqlExecution execution;

    public DocCreate(AllConfiguration all, ApplicationContext appContext, EasyapiBindSqlExecution execution) {
        this.all = all;
        this.appContext = appContext;
        this.execution = execution;
    }

    public void createApi() {
        EasyapiConfiguration configuration = ProjectContext.allConfiguration.getConfiguration();
        Set<Class> set = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().readControllers(this.appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        if (configuration.isRenewDoc()) {
            DBModuleInterfaceEntity upgrade = new DBModuleInterfaceEntity();
            upgrade.setUpgradeStatus(1);
            this.execution.update(EasyapiBindSQLExecuter.build(upgrade).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId, new Boolean[0]));
        }
        for (Class aClass : set) {
            List<DocInterfaceBean> interfaces;
            DocClassBean api = this.createControllerApi(aClass);
            DBModuleControllerEntity controllerBean = api.getController();
            if (controllerBean == null) continue;
            DBModuleControllerEntity queryController = (DBModuleControllerEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(BaseDbEntity::getProjectId, (Object)controllerBean.getProjectId(), new Boolean[0]).eq(DBModuleControllerEntity::getModuleId, (Object)controllerBean.getModuleId(), new Boolean[0]).eq(DBModuleControllerEntity::getClassName, (Object)controllerBean.getClassName(), new Boolean[0]));
            if (queryController == null) {
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                this.execution.insert(controllerBean);
                queryController = controllerBean;
            } else {
                Long id = queryController.getId();
                BeanUtils.copyProperties((Object)controllerBean, (Object)queryController);
                queryController.setId(id);
                this.execution.update(queryController);
            }
            if ((interfaces = api.getInterfaces()) == null || interfaces.isEmpty()) continue;
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setModuleId(ProjectContext.currentModuleId);
            queryInterface.setControllerId(queryController.getId());
            List<DBModuleInterfaceEntity> apiInterfaceBeans = this.execution.select(queryInterface);
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList<DBModuleInterfaceEntity>();
            }
            Map allExistInterface = apiInterfaceBeans.stream().collect(Collectors.toMap(DBModuleInterfaceEntity::getUnique, Function.identity()));
            for (DocInterfaceBean itf : interfaces) {
                List<DocParamEntity> nowParams;
                List<DocParamEntity> oldParams;
                DBModuleInterfaceEntity interfaceBean = itf.getInterfaceBean();
                DBInterfaceParamEntity requestParam = itf.getRequestParam();
                DBModuleInterfaceEntity dbFindInterface = (DBModuleInterfaceEntity)allExistInterface.get(interfaceBean.getUnique());
                if (dbFindInterface != null && !dbFindInterface.getShow().equals(interfaceBean.getShow())) {
                    dbFindInterface.setShow(interfaceBean.getShow());
                    this.execution.update(dbFindInterface);
                }
                if (dbFindInterface != null && dbFindInterface.getUpgradeStatus() == 0) continue;
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setModuleId(queryController.getModuleId());
                interfaceBean.setProjectId(queryController.getProjectId());
                if (dbFindInterface != null) {
                    interfaceBean.setId(dbFindInterface.getId());
                    interfaceBean.setUpgradeStatus(0);
                    if (interfaceBean.getRenewType().equals(RenewType.skip.getType())) continue;
                    if (interfaceBean.getRenewType().equals(RenewType.increment.getType())) {
                        interfaceBean.mergin(dbFindInterface);
                    }
                    if (StringUtil.isEmpty(dbFindInterface.getOrigin())) {
                        interfaceBean.createOrigin();
                    } else {
                        interfaceBean.setOrigin(dbFindInterface.getOrigin());
                    }
                    this.execution.update(interfaceBean);
                } else {
                    this.execution.insert(interfaceBean);
                }
                allExistInterface.put(interfaceBean.getUnique(), interfaceBean);
                EasyapiBindSQLExecuter executer = EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, (Object)interfaceBean.getId(), new Boolean[0]);
                DBInterfaceParamEntity old = (DBInterfaceParamEntity)this.execution.selectOne(executer);
                requestParam.setInterfaceId(interfaceBean.getId());
                requestParam.setProjectId(interfaceBean.getProjectId());
                if (old == null) {
                    this.execution.insert(requestParam);
                    continue;
                }
                if (!StringUtil.isEmpty(requestParam.getRequestParamJson()) && !StringUtil.isEmpty(old.getRequestParamJson())) {
                    oldParams = JsonUtil.jsonToList(old.getRequestParamJson(), DocParamEntity.class);
                    nowParams = JsonUtil.jsonToList(requestParam.getRequestParamJson(), DocParamEntity.class);
                    this.paramsMergin(nowParams, oldParams.stream().collect(Collectors.toMap(DBParamEntity::getUnique, Function.identity())));
                    requestParam.setRequestParamJson(JsonUtil.beanToJson(nowParams));
                }
                if (!StringUtil.isEmpty(requestParam.getResponseParamJson()) && !StringUtil.isEmpty(old.getResponseParamJson())) {
                    oldParams = JsonUtil.jsonToList(old.getResponseParamJson(), DocParamEntity.class);
                    nowParams = JsonUtil.jsonToList(requestParam.getResponseParamJson(), DocParamEntity.class);
                    this.paramsMergin(nowParams, oldParams.stream().collect(Collectors.toMap(DBParamEntity::getUnique, Function.identity())));
                    requestParam.setResponseParamJson(JsonUtil.beanToJson(nowParams));
                }
                requestParam.setId(old.getId());
                this.execution.update(requestParam);
            }
        }
    }

    private void paramsMergin(List<DocParamEntity> now, Map<String, DocParamEntity> old) {
        if (now == null || now.isEmpty()) {
            return;
        }
        for (DocParamEntity nowParam : now) {
            DocParamEntity oldParam = old.get(nowParam.getUnique());
            if (oldParam != null && !StringUtil.isEmpty(oldParam.getOrigin())) {
                DocParamEntity origin = JsonUtil.jsonToBean(oldParam.getOrigin(), DocParamEntity.class);
                this.paramsMergin(nowParam, oldParam, origin);
                nowParam.setOrigin(JsonUtil.beanToJson(origin));
            }
            if (nowParam.getChildren() == null || nowParam.getChildren().isEmpty()) continue;
            this.paramsMergin(nowParam.getChildren(), old);
        }
    }

    private void paramsMergin(DocParamEntity now, DocParamEntity old, DocParamEntity origin) {
        if (now.getRenewType().equals(RenewType.skip.getType())) {
            BeanUtils.copyProperties((Object)old, (Object)now);
            return;
        }
        if (now.getRenewType().equals(RenewType.overwrite.getType())) {
            return;
        }
        EasyapiOriginUtil.mergin(now, old, origin);
    }

    public DocClassBean createControllerApi(Class aClass) {
        String canonicalName = aClass.getCanonicalName();
        String controllerPath = ProjectContext.projectBasePath + File.separator + aClass.getCanonicalName().replace(".", File.separator) + ".java";
        JavaSourceReader controllerSourceReader = JavaSourceReader.builder(new File(controllerPath));
        ApiExtra extra = new ApiExtra();
        extra.setControllerClass(aClass);
        extra.setControllerComment(controllerSourceReader.getComment());
        if (!StringUtil.isEmpty(this.all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(this.all.getConfiguration().getScanPackage())) {
            return DocClassBean.EMPTY;
        }
        if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().ignore(aClass, extra)) {
            return DocClassBean.EMPTY;
        }
        DocClassBean result = new DocClassBean();
        DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass).setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter()).setExtra(extra).buildController();
        controllerBean.setProjectId(ProjectContext.currentProjectId);
        controllerBean.setModuleId(ProjectContext.currentModuleId);
        result.setController(controllerBean);
        extra.setDbController(controllerBean);
        List<Method> methods = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().readAllInterfaces(aClass, extra);
        List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
        HashMap readMethodParamComment = new HashMap();
        for (MethodComment comment : methodComment) {
            List<SourceParameterComment> parameters = comment.getParameters();
            HashMap<String, String> map = new HashMap<String, String>();
            for (SourceParameterComment parameter : parameters) {
                map.put(parameter.getName(), parameter.getComment());
            }
            readMethodParamComment.put(comment.getName(), map);
        }
        for (Method method : methods) {
            if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().ignore(method, extra)) continue;
            MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
            extra.setMethod(method);
            extra.setMethodComment(methodSourceComment);
            DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method).setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter()).setApiExtra(extra).buildInterface();
            interfaceBean.setProjectId(controllerBean.getProjectId());
            interfaceBean.setModuleId(controllerBean.getModuleId());
            interfaceBean.setControllerClass(controllerBean.getClassName());
            interfaceBean.setControllerId(controllerBean.getId());
            extra.setDbInterface(interfaceBean);
            List<String> customSearch = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().customSearch(method, extra);
            interfaceBean.setCustomTags(customSearch == null ? "" : String.join((CharSequence)",", customSearch));
            if (!StringUtil.isEmpty(interfaceBean.getCustomTags()) && interfaceBean.getCustomTags().length() > 150) {
                interfaceBean.setCustomTags(interfaceBean.getCustomTags().substring(0, 150));
            }
            interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(interfaceBean));
            DocInterfaceBean docInterfaceBean = new DocInterfaceBean();
            docInterfaceBean.setInterfaceBean(interfaceBean);
            MethodParamsCreator methodParamsCreator = MethodParamsCreator.build(aClass, method).withBeanCreator(JavaBeanCreator.builder(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter(), ProjectContext.projectBasePath, ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter(), extra)).withMockFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter()).withReqFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadRequestParamApiFilter()).withResFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadResponseParamApiFilter()).withBeanFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter()).withExtra(extra).create();
            String requestParams = JsonUtil.beanToJson(methodParamsCreator.getRequestParameters());
            DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setInterfaceId(interfaceBean.getId());
            reqPram.setCreateTime(System.currentTimeMillis());
            reqPram.setUpdateTime(System.currentTimeMillis());
            reqPram.setRequestParamJson(requestParams);
            reqPram.setResponseParamJson(JsonUtil.beanToJson(methodParamsCreator.getReturnParameter()));
            reqPram.setResponseMock(methodParamsCreator.getResponseMock());
            reqPram.setRequestMock(methodParamsCreator.getRequestMock());
            docInterfaceBean.setRequestParam(reqPram);
            result.getInterfaces().add(docInterfaceBean);
        }
        return result;
    }

    public static void main(String[] args) {
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(new EasyapiConfiguration());
        all.setDataConfiguration(new EasyapiDataConfiguration());
        all.setFilterClassConfiguration(new EasyapiFilterConfiguration());
        all.setFilterBeanConfiguration(new EasyapiFilterBeanConfiguration());
        all.setSyncRemoteConfiguration(new EasyapiSyncRemoteConfiguration());
        all.setUnitConfiguration(new EasyapiUnitConfiguration());
        all.setUserConfiguration(new EasyapiUserConfiguration());
        EasyapiFilterBeanConfiguration beanFilter = all.getFilterBeanConfiguration();
        beanFilter.setReadBeanApiFilter(new DefaultReadJavaBeanApi());
        beanFilter.setReadControllerApiFilter(new DefaultReadControllerApi());
        beanFilter.setReadInterfaceApiFilter(new DefaultReadInterfaceApi());
        beanFilter.setReadMockTemplateFilter(new DefaultReadMockTemplate());
        beanFilter.setReadRequestParamApiFilter(new DefaultReadRequestParamApi());
        beanFilter.setReadResponseParamApiFilter(new DefaultReadResponseParamApi());
        ProjectContext.allConfiguration = all;
        ProjectContext.projectBasePath = "D:\\self\\easyapi\\easyapi\\src\\main\\java";
        DocCreate create = new DocCreate(all, null, null);
        DocClassBean doc = create.createControllerApi(TestController.class);
        Pattern pvalue = Pattern.compile("\"className\":\"(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{0,}\"");
        String context = JsonUtil.beanToJson(doc.getInterfaces().get(0).getRequestParam());
        Matcher matcher = pvalue.matcher(context);
        while (matcher.find()) {
            String group = matcher.group();
            while (context.contains(group)) {
                context = context.replaceFirst(group, "\"className\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
            }
        }
        System.out.println(doc.getInterfaces());
    }
}

