/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadJavaBeanApiFilter;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.filter.ReadRequestParamApiFilter;
import cn.easyutil.easyapi.filter.ReadResponseParamApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MethodParamsCreator {
    private Class clazz;
    private Method method;
    private ApiExtra extra;
    private ReadRequestParamApiFilter reqFilter = new DefaultReadRequestParamApi();
    private ReadResponseParamApiFilter resFilter = new DefaultReadResponseParamApi();
    private ReadJavaBeanApiFilter javaBeanApiFilter = new DefaultReadJavaBeanApi();
    private ReadMockTemplateFilter mockFilter = new DefaultReadMockTemplate(ElExpression.with(DefaultSpelMethodParser.get()));
    private List<DocParamEntity> requestParameters = new ArrayList<DocParamEntity>();
    private List<DocParamEntity> returnParameter = new ArrayList<DocParamEntity>();
    private String responseMock = "";
    private String requestMock = "";
    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz, Method method) {
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateFilter mockFilter) {
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestParamApiFilter reqFilter) {
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseParamApiFilter resFilter) {
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadJavaBeanApiFilter beanFilter) {
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator) {
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method) {
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create() {
        try {
            this.createParameters();
            this.createReturnType();
            MockProcess2 mocker = MockProcess2.with(this.mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(this.requestParameters);
            Object res = mocker.mockByApiParams(this.returnParameter);
            this.requestMock = ObjectUtil.isBaseObject(req) ? req.toString() : JsonUtil.beanToJson(req);
            this.responseMock = ObjectUtil.isBaseObject(res) ? res.toString() : JsonUtil.beanToJson(res);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("\u63a5\u53e3\u53c2\u6570\u6784\u5efa\u5931\u8d25:" + this.clazz.getCanonicalName() + "." + this.method.getName());
        }
    }

    private void createParameters() {
        this.extra.setParameter(null);
        List<MethodParam> params = this.reqFilter.params(this.method, this.extra);
        if (params == null) {
            return;
        }
        for (MethodParam param : params) {
            Parameter parameter = param.getParameter();
            String paramName = param.getParamName();
            Type paramType = param.getParamType();
            Class ownerClass = GenericTypeUtil.getOwnerClass(paramType);
            this.extra.setModelClass(ownerClass);
            this.extra.setParameter(parameter);
            if (this.reqFilter.ignore(paramType, ownerClass, this.extra)) continue;
            if (paramType == null || ownerClass == null) {
                return;
            }
            String description = this.reqFilter.description(paramType, paramName, this.extra);
            if (StringUtil.isEmpty(description)) {
                description = this.extra.getMethodComment().getParameter(paramName).getComment();
            }
            JavaType javaType = JavaType.getJavaTypeByType(paramType);
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(description);
            entity.setMockTemplate(this.reqFilter.mockTemplate(paramType, this.extra));
            entity.setName(paramName);
            entity.setClassName(ownerClass.getCanonicalName());
            entity.setRequired(this.reqFilter.required(paramType, this.extra) ? 1 : 0);
            entity.setShow(this.reqFilter.show(paramType, this.extra) ? 1 : 0);
            entity.setJavaType(javaType.getType());
            this.requestParameters.addAll(this.createParam(paramType, entity));
        }
    }

    private void createReturnType() {
        this.extra.setReturnType(null);
        List<MethodParam> types = this.resFilter.returnTypes(this.method, this.extra);
        if (types == null) {
            return;
        }
        this.extra.setMethod(this.method);
        for (MethodParam param : types) {
            Type type = param.getParamType();
            if (type == Void.TYPE) {
                return;
            }
            this.extra.setReturnType(type);
            Class ownerClass = GenericTypeUtil.getOwnerClass(type);
            GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
            this.extra.setModelClass(ownerClass);
            if (type == null || ownerClass == null) {
                return;
            }
            if (this.resFilter.ignore(type, ownerClass, bind, this.extra)) {
                return;
            }
            JavaType javaType = JavaType.getJavaTypeByType(type);
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(this.resFilter.description(type, this.extra));
            entity.setMockTemplate(this.resFilter.mockTemplate(type, this.extra));
            entity.setRequired(this.resFilter.required(type, ownerClass, bind, this.extra) ? 1 : 0);
            entity.setShow(this.resFilter.show(type, ownerClass, bind, this.extra) ? 1 : 0);
            entity.setName("_null");
            if (!StringUtil.isEmpty(param.getParamName())) {
                entity.setName(param.getParamName());
            }
            entity.setClassName(ownerClass.getCanonicalName());
            entity.setJavaType(javaType.getType());
            List<DocParamEntity> paramsEntity = this.createParam(type, entity);
            if (entity.getName().equals("_null")) {
                this.returnParameter.addAll(paramsEntity);
                continue;
            }
            if (paramsEntity.size() != 1 || !paramsEntity.get(0).getUnique().equals(entity.getUnique())) {
                entity.setChildren(paramsEntity);
            }
            this.returnParameter.add(entity);
        }
    }

    private List<DocParamEntity> createParam(Type type, DocParamEntity entity) {
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        JavaType javaType = JavaType.getType(entity.getJavaType());
        HashMap<String, List<DocParamEntity>> exists = new HashMap<String, List<DocParamEntity>>();
        if (javaType == JavaType.Object) {
            return this.javaBeanCreator.readBean(type, bind, exists);
        }
        entity.setClassName(GenericTypeUtil.getOwnerClass(type).getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType) {
            case Array: {
                entity.setChildren(this.javaBeanCreator.readArray(type, bind));
                break;
            }
            case ArrayObject: {
                entity.setChildren(this.javaBeanCreator.readArrayObject(type, bind, exists));
            }
        }
        Object mockValue = this.mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = this.extra.getControllerClass().getCanonicalName() + this.extra.getMethod().toGenericString() + entity.getClassName() + entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        RenewType renewType = this.javaBeanApiFilter.renewType(this.extra.getModelClass(), bind, this.extra);
        entity.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
        return Collections.singletonList(entity);
    }

    public List<DocParamEntity> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return this.returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return this.responseMock;
    }

    public String getRequestMock() {
        return this.requestMock;
    }
}

