/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.LoginDto;
import cn.easyutil.easyapi.interview.dto.SelectUsersDto;
import cn.easyutil.easyapi.interview.dto.UpdatePasswordDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.session.SessionUser;
import cn.easyutil.easyapi.service.RoleAuthService;
import cn.easyutil.easyapi.service.RoleProjectService;
import cn.easyutil.easyapi.service.RoleService;
import cn.easyutil.easyapi.service.UserService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUserController"})
@RequestMapping(value={"/easyapi/doc/user"})
public class UserController {
    @Resource(name="easyapiUserService")
    private UserService userService;
    @Resource(name="easyapiRoleService")
    private RoleService roleService;
    @Resource(name="easyapiRoleAuthService")
    private RoleAuthService authService;
    @Resource(name="easyapiRoleProjectService")
    private RoleProjectService roleProjectService;

    @ApidocComment(value="\u767b\u9646\u63a5\u53e3")
    @PostMapping(value={"/login"})
    @AccessAuth(code=1000)
    public DBUserEntity login(@RequestBody LoginDto dto) {
        AssertUtil.isNull((Object)StringUtil.isEmpty(dto.getAccount()), "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull((Object)StringUtil.isEmpty(dto.getPassword()), "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity user = this.userService.getByAccount(dto.getAccount());
        AssertUtil.isNull((Object)user, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(!user.getPassword().equals(StringUtil.toMD5(dto.getPassword())), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(user.getDisable() == 1, "\u60a8\u5df2\u88ab\u7981\u7528");
        SessionUser sessionUser = new SessionUser();
        BeanUtils.copyProperties((Object)user, (Object)sessionUser);
        CurrentSession.loginSuccess(sessionUser);
        if (user.getSuperAdminStatus() == 1) {
            return user;
        }
        DBRoleProjectEntity rp = new DBRoleProjectEntity();
        rp.setRoleId(user.getRoleId());
        List<DBRoleProjectEntity> pList = this.roleProjectService.list(rp);
        if (pList == null) {
            return user;
        }
        HashMap<Long, List<Integer>> auths = new HashMap<Long, List<Integer>>();
        for (DBRoleProjectEntity item : pList) {
            DBRoleAuthEntity ra = new DBRoleAuthEntity();
            ra.setRoleId(item.getRoleId());
            ra.setProjectId(item.getProjectId());
            List<DBRoleAuthEntity> list = this.authService.list(ra);
            if (list == null) continue;
            auths.put(item.getProjectId(), list.stream().map(auth -> auth.getAuthCode()).collect(Collectors.toList()));
        }
        sessionUser.setProjectIds(auths);
        return user;
    }

    @ApidocComment(value="\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801")
    @PostMapping(value={"/updatePassword"})
    @AccessAuth(code=1000)
    public void updatePassword(@RequestBody UpdatePasswordDto dto) {
        SessionUser user = CurrentSession.getCurrentUser();
        AssertUtil.isTrue(!user.getPassword().equals(StringUtil.toMD5(dto.getOldPassword())), "\u65e7\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e");
        user.setPassword(dto.getNewPassword());
        DBUserEntity userEntity = new DBUserEntity();
        userEntity.setId(user.getId());
        userEntity.setPassword(StringUtil.toMD5(dto.getNewPassword()));
        this.userService.update(userEntity);
    }

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/selectUsers"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBUserEntity> selectUsers(@RequestBody SelectUsersDto dto) {
        SessionUser currentUser = CurrentSession.getCurrentUser();
        if (currentUser.getSuperAdminStatus() == 0) {
            Long currentProjectId = CurrentSession.getCurrentProjectId();
            dto.setProjectId(currentProjectId);
        }
        DBUserEntity query = new DBUserEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        query.setHidden(0);
        EasyApiBindSqlResult page = this.userService.page(query, dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/updateUser"})
    @AccessAuth(code=1000)
    public void updateUser(@RequestBody DBUserEntity user) {
        AssertUtil.isNull((Object)user.getId(), "\u8981\u4fee\u6539\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity query = (DBUserEntity)this.userService.getById(user.getId());
        AssertUtil.isNull((Object)query, "\u7528\u6237\u4e0d\u5b58\u5728");
        if (!StringUtil.isEmpty(user.getAccount()) && !query.getAccount().equals(user.getAccount())) {
            DBUserEntity byAccount = this.userService.getByAccount(user.getAccount());
            AssertUtil.isTrue(byAccount != null, "\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (!StringUtil.isEmpty(user.getPassword()) && !user.getPassword().equals(query.getPassword())) {
            user.setPassword(StringUtil.toMD5(user.getPassword()));
        }
        this.userService.update(user);
    }

    @ApidocComment(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/deleteUser"})
    @AccessAuth(code=1000)
    public void deleteUser(@RequestBody IdDto dto) {
        this.userService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6dfb\u52a0\u7528\u6237")
    @PostMapping(value={"/addUser"})
    @AccessAuth(code=1000)
    public void addUser(@RequestBody DBUserEntity entity) {
        AssertUtil.isNull((Object)StringUtil.isEmpty(entity.getAccount()), "\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity byAccount = this.userService.getByAccount(entity.getAccount());
        AssertUtil.isTrue(byAccount != null, "\u8d26\u53f7\u5df2\u5b58\u5728");
        entity.setId(null);
        if (entity.getRoleId() == null) {
            DBRoleEntity defaultRole = (DBRoleEntity)this.roleService.get(EasyapiBindSQLExecuter.build(new DBRoleEntity()).eq(DBRoleEntity::getDefaultRole, (Object)1, new Boolean[0]));
            entity.setRoleId(defaultRole.getId());
        }
        if (StringUtil.isEmpty(entity.getPassword())) {
            entity.setPassword(StringUtil.toMD5("123456"));
        } else {
            entity.setPassword(StringUtil.toMD5(entity.getPassword()));
        }
        if (entity.getProjectId() == null) {
            entity.setProjectId(ProjectContext.currentProjectId);
        }
        this.userService.insert(entity);
    }
}

