/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.controller.SimpleApidocController;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SelectGroupsDto;
import cn.easyutil.easyapi.interview.entity.ScriptSourceBean;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.service.SimpleUnitService;
import cn.easyutil.easyapi.service.TestGroupService;
import cn.easyutil.easyapi.service.TestInfoService;
import cn.easyutil.easyapi.service.TestService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUnitController"})
@RequestMapping(value={"/easyapi/doc/unit"})
public class UnitController {
    @Resource(name="easyapiTestGroupService")
    private TestGroupService groupService;
    @Resource(name="easyapiTestService")
    private TestService testService;
    @Resource(name="easyapiTestInfoService")
    private TestInfoService testInfoService;
    @Resource(name="easyapiSimpleUnitService")
    private SimpleUnitService simpleUnitService;
    @Resource(name="easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4\u5217\u8868")
    @PostMapping(value={"/selectGroups"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestGroupEntity> selectGroups(@RequestBody SelectGroupsDto dto) {
        DBComplexTestGroupEntity query = new DBComplexTestGroupEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        query.setName(null);
        EasyApiBindSqlResult page = this.groupService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u6dfb\u52a0\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/addGroups"})
    @AccessAuth(code=1000)
    public void addGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isEmpty(entity.getName(), "\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/updateGroups"})
    @AccessAuth(code=1000)
    public void updateGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/delGroups"})
    @AccessAuth(code=1000)
    public void delGroups(@RequestBody IdDto dto) {
        this.groupService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/selectTests"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestEntity> selectTests(@RequestBody SelectGroupsDto dto) {
        DBComplexTestEntity query = new DBComplexTestEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        EasyApiBindSqlResult page = this.testService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/delTests"})
    @AccessAuth(code=1000)
    public void delTests(@RequestBody IdDto dto) {
        this.testService.deleteById(dto.getId());
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setTestId(dto.getId());
        this.testInfoService.delete(entity);
    }

    @ApidocComment(value="\u4fdd\u5b58\u6d4b\u8bd5\u8bb0\u5f55")
    @PostMapping(value={"/saveUnit"})
    @AccessAuth(code=1000)
    public void saveUnit(@RequestBody DBSimpleUnitEntity entity) {
        AssertUtil.isNull((Object)entity.getInterfaceId(), "\u672a\u77e5\u63a5\u53e3");
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setType(1);
        this.simpleUnitService.insert(entity);
    }

    @ApidocComment(value="\u83b7\u53d6\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2\u8bb0\u5f55")
    @AccessAuth(code=1000)
    public List<DBSimpleUnitEntity> getAllUnit(@RequestBody IdDto dto) {
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return this.simpleUnitService.list(EasyapiBindSQLExecuter.build(unit).orderBy(BaseDbEntity::getCreateTime, false));
    }

    @ApidocComment(value="\u83b7\u53d6\u4e0a\u6b21\u63a5\u53e3\u6267\u884c\u76f8\u5173\u53c2\u6570")
    @AccessAuth(code=1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody IdDto dto) {
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setType(0);
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return this.simpleUnitService.get(unit);
    }

    @ApidocComment(value="\u4fee\u6539\u6267\u884c\u7ed3\u679c")
    @AccessAuth(code=1000)
    public void updateUnit(@RequestBody DBSimpleUnitEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u7f3a\u5c11id");
        this.simpleUnitService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u6d4b\u8bd5\u8bb0\u5f55")
    @AccessAuth(code=1000)
    public void delUnit(@RequestBody IdDto dto) {
        this.simpleUnitService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6267\u884c\u7f51\u7edc\u8bf7\u6c42")
    @AccessAuth(code=1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity) {
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        unit.setInterfaceId(interfaceId);
        unit.setUserId(userId);
        unit.setType(0);
        this.simpleUnitService.delete(unit);
        unit.setName("LATEST");
        unit.setRequestUrl(entity.getSaveUrl());
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setUseStyleType(entity.getUseStyleType());
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonPreScripts(entity.getSavePreScripts() == null ? "[]" : entity.getSavePreScripts());
        unit.setJsonPostScripts(entity.getSavePostScripts() == null ? "[]" : entity.getSavePostScripts());
        this.simpleUnitService.insert(unit);
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();
        String responseMsg = httpRes.getResponseMsg();
        unit.setJsonResponse(responseMsg);
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime - startTime);
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        if (JsonUtil.isJson(httpRes.getResponseMsg())) {
            result.setResponseMsg(JsonUtil.jsonToMap(httpRes.getResponseMsg()));
        }
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime - startTime);
        result.setUnitId(unit.getId());
        unit.setJsonResponse(httpRes.getResponseMsg());
        this.simpleUnitService.update(unit);
        return result;
    }

    private ScriptSourceBean doScript(ScriptSourceBean source, DBModuleScriptEntity script) {
        String valType = script.getValType();
        String condition = JavaScriptExec.getVal(source, StringUtil.isEmpty(script.getCondition()) ? "true" : script.getCondition());
        if (!Boolean.parseBoolean(condition)) {
            return source;
        }
        if (valType.equals("header") || valType.equals("env")) {
            String val = JavaScriptExec.getVal(source, script.getScript());
            if (valType.equals("header")) {
                DBModuleHeaderEntity header = new DBModuleHeaderEntity();
                header.setKey(script.getValName());
                header.setVal(val);
                header.setModuleId(CurrentSession.getCurrentModuleId());
                header.setProjectId(CurrentSession.getCurrentProjectId());
                header.setUserId(CurrentSession.getCurrentUser().getId());
                this.simpleApidocController.addHeader(header);
            } else {
                DBMouduleEnvEntity env = new DBMouduleEnvEntity();
                env.setName(Optional.ofNullable(script.getDescription()).orElse(script.getValName()));
                env.setKey(script.getValName());
                env.setVal(val);
                env.setModuleId(CurrentSession.getCurrentModuleId());
                env.setProjectId(CurrentSession.getCurrentProjectId());
                env.setUserId(CurrentSession.getCurrentUser().getId());
                this.simpleApidocController.addEnv(env);
            }
            return source;
        }
        return JavaScriptExec.parseParams(source, script);
    }
}

