/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.Page;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.controller.ComplexApidocController;
import cn.easyutil.easyapi.interview.controller.ModuleController;
import cn.easyutil.easyapi.interview.controller.ProjectController;
import cn.easyutil.easyapi.interview.controller.RoleAuthController;
import cn.easyutil.easyapi.interview.controller.SimpleApidocController;
import cn.easyutil.easyapi.interview.controller.UnitController;
import cn.easyutil.easyapi.interview.controller.UserController;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.UnifiedAccessDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.javadoc.html.StaticDocCreate;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUnifiedAccessController"})
@RequestMapping(value={"/easyapi/doc/unified"})
public class UnifiedAccessController {
    private static final Map<String, Object> emptyObject = new HashMap<String, Object>();
    private static final List<?> emptyList = Collections.emptyList();
    @Resource(name="easyapiComplexApidocController")
    private ComplexApidocController complexApidocController;
    @Resource(name="easyapiModuleController")
    private ModuleController moduleController;
    @Resource(name="easyapiProjectController")
    private ProjectController projectController;
    @Resource(name="easyapiRoleAuthController")
    private RoleAuthController roleAuthController;
    @Resource(name="easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;
    @Resource(name="easyapiUnitController")
    private UnitController unitController;
    @Resource(name="easyapiUserController")
    private UserController userController;
    @Resource(name="easyapiStaticDocCreate")
    private StaticDocCreate staticDocCreate;

    @GetMapping(value={"/export"})
    public void export(HttpServletResponse response) {
        try {
            this.staticDocCreate.export(response);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/mock"})
    public Object mock(String path, String tag) {
        return this.simpleApidocController.mock(path, tag);
    }

    @GetMapping(value={"/get"})
    public ResponseBody get(String text) {
        UnifiedAccessDto dto;
        try {
            dto = JsonUtil.jsonToBean(StringUtil.UrlDecode(text), UnifiedAccessDto.class);
        }
        catch (Exception e) {
            return ResponseBody.error("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        return this.post(dto);
    }

    @PostMapping(value={"/post"})
    public ResponseBody post(@RequestBody UnifiedAccessDto dto) {
        if (dto == null) {
            return ResponseBody.error("\u53c2\u6570\u7f3a\u5931");
        }
        if (StringUtil.isEmpty(dto.getApi())) {
            return ResponseBody.error("\u672a\u63d0\u4ea4\u63a7\u5236\u5668\u53c2\u6570");
        }
        ChoosController cc = this.choosController(dto.getApi());
        if (cc == null) {
            return ResponseBody.error("\u63a7\u5236\u5668\u4e0d\u5b58\u5728");
        }
        CurrentSession.getRequest().getSession().setAttribute("projectId", (Object)dto.getProjectId());
        CurrentSession.getRequest().getSession().setAttribute("moduleId", (Object)dto.getModuleId());
        Method[] methods = cc.getController().getClass().getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!m.getName().equals(cc.getMethodName()) || m.getDeclaredAnnotation(AccessAuth.class) == null) continue;
            method = m;
            break;
        }
        if (method == null) {
            return ResponseBody.error("\u63a7\u5236\u5668\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        try {
            Object result;
            if (!dto.getApi().equals("user::login")) {
                CurrentSession.getCurrentUser();
            }
            if (!StringUtil.isEmpty(dto.getBody())) {
                Class<?> parameterType = method.getParameterTypes()[0];
                result = method.invoke(cc.getController(), JsonUtil.jsonToBean(dto.getBody(), parameterType));
            } else {
                result = method.invoke(cc.getController(), new Object[0]);
            }
            return this.postRequest(result, method);
        }
        catch (Exception e) {
            Throwable ex = e;
            if (e instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)e).getTargetException();
            }
            if (ex instanceof ApidocException) {
                ApidocException ae = (ApidocException)ex;
                return ResponseBody.error(ae.getCode(), ae.getMessage());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            ex.printStackTrace(print);
            return ResponseBody.error(new String(out.toByteArray()));
        }
    }

    private ResponseBody postRequest(Object result, Method method) {
        if (result instanceof ResponseBody) {
            return (ResponseBody)result;
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            return ResponseBody.success(result == null ? emptyList : result);
        }
        if (EasyApiBindSqlResult.class.isAssignableFrom(method.getReturnType())) {
            EasyApiBindSqlResult data = (EasyApiBindSqlResult)result;
            ResponseBody body = new ResponseBody();
            body.setData(data.getResultList());
            body.setCode(200);
            Page page = new Page();
            BeanUtils.copyProperties((Object)data.getPage(), (Object)page);
            body.setPage(page);
            return body;
        }
        return ResponseBody.success(result == null ? emptyObject : result);
    }

    private ChoosController choosController(String api) {
        if (StringUtil.isEmpty(api)) {
            return null;
        }
        String[] split = (api = StringUtil.UrlDecode(api)).split("::");
        if (split.length != 2) {
            return null;
        }
        ChoosController cc = new ChoosController();
        switch (split[0]) {
            case "complex": {
                cc.setController(this.complexApidocController);
                break;
            }
            case "module": {
                cc.setController(this.moduleController);
                break;
            }
            case "project": {
                cc.setController(this.projectController);
                break;
            }
            case "role": {
                cc.setController(this.roleAuthController);
                break;
            }
            case "simple": {
                cc.setController(this.simpleApidocController);
                break;
            }
            case "unit": {
                cc.setController(this.unitController);
                break;
            }
            case "user": {
                cc.setController(this.userController);
                break;
            }
            default: {
                return null;
            }
        }
        cc.setMethodName(split[1]);
        return cc;
    }

    private void checkAuth(String api, Method method) {
        if (api.equals("user::login")) {
            return;
        }
        AccessAuth accessAuth = method.getDeclaredAnnotation(AccessAuth.class);
        AssertUtil.isNull((Object)accessAuth, "\u8be5\u63a5\u53e3\u672a\u5f00\u901a\u8bbf\u95ee\u6743\u9650");
        AssertUtil.isTrue(accessAuth.code() <= 0, "\u8be5\u63a5\u53e3\u672a\u5f00\u901a\u8bbf\u95ee\u6743\u9650");
        AssertUtil.isTrue(!CurrentSession.getCurrentUser().getProjectIds().containsKey(CurrentSession.getCurrentProjectId()), "\u60a8\u6ca1\u6709\u8be5\u9879\u76ee\u8bbf\u95ee\u6743\u9650");
        List<Integer> authCodes = CurrentSession.getCurrentUser().getProjectIds().get(CurrentSession.getCurrentProjectId());
        AssertUtil.isTrue(!authCodes.contains(accessAuth.code()), "\u60a8\u6ca1\u6709\u8be5\u63a5\u53e3\u8bbf\u95ee\u6743\u9650");
    }

    static class ChoosController {
        private Object controller;
        private String methodName;

        ChoosController() {
        }

        public Object getController() {
            return this.controller;
        }

        public void setController(Object controller) {
            this.controller = controller;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }
    }
}

