/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.auth.AuthMoudleParseBean;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.interview.dto.BindProjectsDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.UpdateRolesDto;
import cn.easyutil.easyapi.interview.dto.UpdateUserAuthCodesDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.session.SessionUser;
import cn.easyutil.easyapi.interview.vo.GetRolesByUserIdVo;
import cn.easyutil.easyapi.service.RoleAuthService;
import cn.easyutil.easyapi.service.RoleProjectService;
import cn.easyutil.easyapi.service.RoleService;
import cn.easyutil.easyapi.service.UserTemporaryAuthService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiRoleAuthController"})
@RequestMapping(value={"/easyapi/doc/role"})
public class RoleAuthController {
    @Resource(name="easyapiRoleService")
    private RoleService roleService;
    @Resource(name="easyapiRoleAuthService")
    private RoleAuthService authService;
    @Resource(name="easyapiRoleProjectService")
    private RoleProjectService roleProjectService;
    @Resource(name="easyapiUserTemporaryAuthService")
    private UserTemporaryAuthService userTemporaryAuthService;

    @ApidocComment(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @PostMapping(value={"/getRoles"})
    @AccessAuth(code=1000)
    public List<DBRoleEntity> getRoles() {
        SessionUser currentUser = CurrentSession.getCurrentUser();
        List<DBRoleEntity> list = this.roleService.list(EasyapiBindSQLExecuter.build(new DBRoleEntity()).eq(!StringUtil.isEmpty(currentUser.getRoleId()), BaseDbEntity::getId, currentUser.getRoleId(), new Boolean[0]));
        return list;
    }

    @ApidocComment(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6743\u9650\u7801")
    @AccessAuth(code=1000)
    public List<GetRolesByUserIdVo> getRolesByUserId(@RequestBody IdDto dto) {
        Long id = dto.getId();
        DBUserTemporaryAuthEntity auth = new DBUserTemporaryAuthEntity();
        auth.setUserId(id);
        List<DBUserTemporaryAuthEntity> authCodes = this.userTemporaryAuthService.list(auth);
        List<Integer> allCodes = AuthMoudle.allCode();
        ArrayList<GetRolesByUserIdVo> vos = new ArrayList<GetRolesByUserIdVo>();
        for (Integer code : allCodes) {
            GetRolesByUserIdVo vo = new GetRolesByUserIdVo();
            vo.setAuthCode(code);
            vo.setCodeName(AuthMoudle.getByCode(code).getMoudleRemark());
            if (authCodes == null || authCodes.isEmpty()) {
                vos.add(vo);
                continue;
            }
            DBUserTemporaryAuthEntity entity = authCodes.stream().filter(ac -> code.equals(ac.getAuthCode())).findFirst().orElse(null);
            if (entity != null) {
                vo.setChecked(true);
            }
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment(value="\u4fee\u6539\u6307\u5b9a\u7528\u6237\u7684\u6743\u9650\u7801")
    @AccessAuth(code=1000)
    public void updateUserAuthCodes(@RequestBody UpdateUserAuthCodesDto dto) {
        Long userId = dto.getUserId();
        List<Integer> codes = dto.getCodes();
        this.userTemporaryAuthService.delByUserId(userId);
        if (codes == null || codes.size() == 0) {
            return;
        }
        ArrayList<DBUserTemporaryAuthEntity> auths = new ArrayList<DBUserTemporaryAuthEntity>();
        for (Integer code : codes) {
            DBUserTemporaryAuthEntity auth = new DBUserTemporaryAuthEntity();
            auth.setUserId(userId);
            auth.setAuthCode(code);
            auths.add(auth);
        }
        this.userTemporaryAuthService.insertAny(auths);
    }

    @ApidocComment(value="\u4fee\u6539\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/updateRoles"})
    @AccessAuth(code=1000)
    public void updateRoles(@RequestBody UpdateRolesDto dto) {
        AssertUtil.isNull((Object)dto.getId(), "\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        DBRoleEntity entity = new DBRoleEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        this.roleService.update(entity);
        if (dto.getAuthCodes() == null) {
            return;
        }
        this.authService.delByRoleId(dto.getId());
        for (Integer authCode : dto.getAuthCodes()) {
            DBRoleAuthEntity auth = new DBRoleAuthEntity();
            auth.setAuthCode(authCode);
            auth.setRoleId(dto.getId());
            this.authService.insert(auth);
        }
    }

    @ApidocComment(value="\u6dfb\u52a0\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/addRoles"})
    @AccessAuth(code=1000)
    public void addRoles(@RequestBody UpdateRolesDto dto) {
        DBRoleEntity entity = new DBRoleEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        this.roleService.insert(entity);
        if (dto.getAuthCodes() == null) {
            return;
        }
        for (Integer authCode : dto.getAuthCodes()) {
            DBRoleAuthEntity auth = new DBRoleAuthEntity();
            auth.setAuthCode(authCode);
            auth.setRoleId(dto.getId());
            this.authService.insert(auth);
        }
    }

    @ApidocComment(value="\u5220\u9664\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/delRoles"})
    @AccessAuth(code=1000)
    public void delRole(@RequestBody IdDto dto) {
        this.roleService.deleteById(dto.getId());
        this.authService.delByRoleId(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u90e8\u6743\u9650\u7801")
    @PostMapping(value={"/getAuthCodes"})
    @AccessAuth(code=1000)
    public List<AuthMoudleParseBean> getAuthCodes() {
        List<AuthMoudle> all = AuthMoudle.allMoudle(CurrentSession.getCurrentUser().getProjectIds().get(CurrentSession.getCurrentProjectId()));
        ArrayList<AuthMoudleParseBean> parses = new ArrayList<AuthMoudleParseBean>();
        for (AuthMoudle authMoudle : all) {
            AuthMoudleParseBean parse = new AuthMoudleParseBean();
            parse.setAuthCode(authMoudle.getAuthCode());
            parse.setMoudleName(authMoudle.getMoudleName());
            parse.setMoudleRemark(authMoudle.getMoudleRemark());
            parses.add(parse);
        }
        return parses;
    }

    @ApidocComment(value="\u83b7\u53d6\u89d2\u8272\u7ed1\u5b9a\u7684\u9879\u76ee\u5217\u8868")
    @PostMapping(value={"/getRoleProjects"})
    @AccessAuth(code=1000)
    public List<DBRoleProjectEntity> getRoleProjects(@RequestBody IdDto dto) {
        SessionUser currentUser = CurrentSession.getCurrentUser();
        if (currentUser.getSuperAdminStatus() != 1) {
            dto.setId(currentUser.getRoleId());
        }
        List<DBRoleProjectEntity> list = this.roleProjectService.getByRoleId(dto.getId());
        return list;
    }

    @ApidocComment(value="\u4fee\u6539\u89d2\u8272\u7ed1\u5b9a\u9879\u76ee\u5217\u8868")
    @PostMapping(value={"/bindProjects"})
    @AccessAuth(code=1000)
    public void bindProjects(@RequestBody BindProjectsDto dto) {
        AssertUtil.isNull((Object)dto.getRoleId(), "\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull(dto.getProjectIds(), "\u9879\u76eeid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.roleProjectService.delByRoleId(dto.getRoleId());
        for (Long projectId : dto.getProjectIds()) {
            DBRoleProjectEntity entity = new DBRoleProjectEntity();
            entity.setRoleId(dto.getRoleId());
            entity.setProjectId(projectId);
            this.roleProjectService.insert(entity);
        }
    }
}

