/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.service.ArticleService;
import cn.easyutil.easyapi.service.ProjectService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiProjectController"})
@RequestMapping(value={"/easyapi/doc/project"})
public class ProjectController {
    @Resource(name="easyapiProjectService")
    private ProjectService projectService;
    @Resource(name="easyapiArticleService")
    private ArticleService articleService;

    @ApidocComment(value="\u83b7\u53d6\u9879\u76ee\u5217\u8868")
    @PostMapping(value={"/getProjects"})
    @AccessAuth(code=1000)
    public List<DBProjectEntity> getProjects() {
        Set<Long> longs = CurrentSession.getCurrentUser().getProjectIds().keySet();
        List<DBProjectEntity> list = this.projectService.list(EasyapiBindSQLExecuter.build(new DBProjectEntity()).in(BaseDbEntity::getId, longs, new Boolean[0]));
        return list;
    }

    @ApidocComment(value="\u4fee\u6539\u9879\u76ee\u4fe1\u606f")
    @PostMapping(value={"/updateProjects"})
    @AccessAuth(code=1000)
    public void updateProjects(@RequestBody DBProjectEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = this.projectService.get(query);
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u9879\u76ee");
        }
        this.projectService.update(entity);
    }

    @ApidocComment(value="\u65b0\u589e\u9879\u76ee")
    @PostMapping(value={"/addProject"})
    @AccessAuth(code=1000)
    public void addProject(@RequestBody DBProjectEntity entity) {
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = this.projectService.get(query);
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u9879\u76ee");
        }
        this.projectService.insert(entity);
    }

    @ApidocComment(value="\u4fdd\u5b58\u6587\u7ae0\u5217\u8868")
    @PostMapping(value={"/saveArticles"})
    @AccessAuth(code=1000)
    public void saveArticles(@RequestBody List<DBArticleEntity> articles) {
        this.articleService.delete(EasyapiBindSQLExecuter.build(new DBArticleEntity()).gte(BaseDbEntity::getId, (Object)1, new Boolean[0]));
        List<DBArticleEntity> list = JsonUtil.jsonToList(JsonUtil.beanToJson(articles), DBArticleEntity.class);
        this.articleService.insertAny(list);
    }

    @ApidocComment(value="\u5220\u9664\u9879\u76ee")
    @PostMapping(value={"/delProject"})
    @AccessAuth(code=1000)
    public void delProject(@RequestBody IdDto dto) {
        this.projectService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f")
    @PostMapping(value={"/getInfo"})
    @AccessAuth(code=1000)
    public DBProjectEntity getInfo() {
        return this.projectService.get(new DBProjectEntity());
    }
}

