/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadControllerApiFilter;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;

public class DefaultReadControllerApi
extends ReadControllerApiFilter {
    @Override
    public Set<Class> readControllers(ApplicationContext springContext) {
        Map beansWithAnnotation = springContext.getBeansWithAnnotation(Controller.class);
        HashSet<Class> set = new HashSet<Class>();
        for (Map.Entry next : beansWithAnnotation.entrySet()) {
            Object value = next.getValue();
            Class<?> aClass = value.getClass();
            if (aClass.getCanonicalName().contains("cn.easyutil.easyapi")) continue;
            if (aClass.getCanonicalName().contains("$$")) {
                set.add(aClass.getSuperclass());
                continue;
            }
            set.add(aClass);
        }
        return set;
    }

    @Override
    public boolean ignore(Class controller, ApiExtra extra) {
        if (controller.getCanonicalName().startsWith("org.springframework")) {
            return true;
        }
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(controller, ApidocComment.class);
        return classAnnotation != null && classAnnotation.size() > 0 && classAnnotation.get(controller.getName()) != null && classAnnotation.get(controller.getName()).ignore();
    }

    @Override
    public boolean show(Class controller, ApiExtra extra) {
        return true;
    }

    @Override
    public String showName(Class controller, ApiExtra extra) {
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(controller, ApidocComment.class);
        if (classAnnotation != null && !classAnnotation.isEmpty()) {
            return classAnnotation.entrySet().iterator().next().getValue().value();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.Api", controller.getAnnotations());
        if (annotation != null) {
            String[] tgs;
            Object tags = AnnotationUtil.getAnnotationValue(annotation, "tags");
            if (tags != null && (tgs = (String[])tags).length > 0 && !StringUtil.isEmpty(tgs[0])) {
                return tgs[0];
            }
            return (String)AnnotationUtil.getAnnotationValue(annotation, "value");
        }
        return extra.getControllerComment().getComment();
    }

    @Override
    public String requestPath(Class controller, ApiExtra extra) {
        String mapping = SpringUtil.getRequestPath(controller);
        if (StringUtil.isEmpty(mapping)) {
            return "";
        }
        String baseUrl = "";
        baseUrl = baseUrl + mapping;
        baseUrl = DefaultReadControllerApi.parseUrl(baseUrl);
        return baseUrl;
    }

    @Override
    public String description(Class controller, ApiExtra extra) {
        return null;
    }

    @Override
    public String author(Class controller, ApiExtra extra) {
        return null;
    }

    private static String parseUrl(String requestUrl) {
        if (StringUtil.isEmpty(requestUrl)) {
            return null;
        }
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}

