/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.util.StringUtil;
import org.apache.http.entity.ContentType;

public enum BodyType {
    FORM(0, ContentType.APPLICATION_FORM_URLENCODED),
    JSON(1, ContentType.APPLICATION_JSON),
    UPLOAD(2, ContentType.APPLICATION_FORM_URLENCODED),
    XML(3, ContentType.APPLICATION_XML),
    RAW(4, ContentType.TEXT_PLAIN),
    DOWNLOAD(5, ContentType.APPLICATION_OCTET_STREAM),
    UNKNOW(-1, null);

    private Integer type;
    private ContentType contentType;

    private BodyType(Integer type, ContentType contentType) {
        this.type = type;
        this.contentType = contentType;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public static BodyType parse(Integer type) {
        BodyType[] values;
        if (StringUtil.isEmpty(type)) {
            return UNKNOW;
        }
        for (BodyType value : values = BodyType.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return UNKNOW;
    }
}

