/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.datasource;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tid;
import cn.easyutil.easyapi.datasource.annotations.Tie;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindPage;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.ClobUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class EasyapiBindSqlExecution {
    private DataSource dataSource;
    private static ThreadLocal<Connection> connect = new ThreadLocal();
    private boolean autuoCommit = true;
    private boolean doLogger = true;
    private String driver = "MYSQL";
    private static final String CONFIG_DEFAULT = "CONFIG_DEFAULT";
    private static final String USER_DEFAULT = "USER_DEFAULT";

    public EasyapiBindSqlExecution(Connection connect) {
        EasyapiBindSqlExecution.connect.set(connect);
    }

    public EasyapiBindSqlExecution() {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConcurrentConnect() {
        Connection connection = connect.get();
        try {
            if (connection != null && !connection.isClosed()) {
                return connection;
            }
            if (this.dataSource != null) {
                connection = this.dataSource.getConnection();
            }
            if (connection == null) {
                throw new RuntimeException("\u65e0\u53ef\u7528\u8fde\u63a5");
            }
            if (connection.isClosed()) {
                throw new RuntimeException("\u8fde\u63a5\u5df2\u5173\u95ed,\u65e0\u53ef\u7528\u8fde\u63a5");
            }
            connection.setAutoCommit(this.autuoCommit);
        }
        catch (SQLException throwables) {
            throw new RuntimeException(throwables);
        }
        connect.set(connection);
        return connection;
    }

    private Connection getConnect() {
        return this.getConcurrentConnect();
    }

    private Object executeInsert(String sql, List<Object> params) {
        if (!sql.toUpperCase().startsWith("INSERT")) {
            throw new RuntimeException("\u5f53\u524d\u975e\u65b0\u589e\u8bed\u53e5");
        }
        Connection connect = this.getConnect();
        try {
            PreparedStatement statement = connect.prepareStatement(sql, 1);
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
            this.executeUpdate(statement);
            this.printLogger("==============================");
            this.printLogger("\u6267\u884c\u65b0\u589e\u8bed\u53e5:" + sql);
            this.printLogger("\u6267\u884c\u53c2\u6570\u4e3a:" + params);
            this.printLogger("==============================");
            ResultSet result = statement.getGeneratedKeys();
            if (result.next()) {
                return result.getObject(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private PreparedStatement executeSql(String sql, List<Object> params) {
        Connection connect = this.getConnect();
        try {
            PreparedStatement statement = connect.prepareStatement(sql);
            this.printLogger("==============================");
            this.printLogger("\u6267\u884c\u8bed\u53e5:" + sql);
            this.printLogger("\u6267\u884c\u53c2\u6570\u4e3a:" + params);
            this.printLogger("==============================");
            if (params == null || params.size() == 0) {
                return statement;
            }
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
            return statement;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Map<String, Object>> executeQuery(PreparedStatement statement) {
        try {
            ResultSet result = statement.executeQuery();
            ResultSetMetaData res = result.getMetaData();
            int count = res.getColumnCount();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (result.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= count; ++i) {
                    map.put(res.getColumnLabel(i), result.getObject(i));
                }
                list.add(map);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int executeUpdate(PreparedStatement statement) {
        try {
            return statement.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Double executeCount(PreparedStatement statement) {
        try {
            ResultSet result = statement.executeQuery();
            Object count = null;
            while (result.next()) {
                count = result.getObject(1);
            }
            if (this.doLogger) {
                this.printLogger("\u5f53\u524d\u67e5\u8be2\u5230\u603b\u6761\u6570\u4e3a:" + count);
            }
            this.toCommit();
            if (count == null) {
                return 0.0;
            }
            return Double.valueOf(count.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autuoCommit = autoCommit;
        try {
            this.getConcurrentConnect().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void toCommit() {
        Connection connection = connect.get();
        try {
            if (connection != null && !connection.isClosed() && !connection.getAutoCommit()) {
                connection.commit();
                connection.close();
            }
            if (!connection.isClosed()) {
                connection.close();
            }
            connect.remove();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commit() {
        this.toCommit();
        this.printLogger("====\u5f53\u524d\u4e8b\u52a1\u88ab\u63d0\u4ea4===");
    }

    public void rollBack() {
    }

    public EasyApiBindSqlResult<Map> queryListPage(String sql, Integer currentPageParam, Integer showCountParam) {
        Object[] objs = new Object[]{};
        return this.queryListPage(sql, currentPageParam, showCountParam, objs);
    }

    public EasyApiBindSqlResult<Map> queryListPage(String sql, Integer currentPageParam, Integer showCountParam, Object ... params) {
        return this.queryListPage(sql, Map.class, currentPageParam, showCountParam, params);
    }

    public <T> EasyApiBindSqlResult<T> queryListPage(String sql, Class<T> clazz, Integer currentPageParam, Integer showCountParam) {
        Object[] objs = new Object[]{};
        return this.queryListPage(sql, clazz, currentPageParam, showCountParam, objs);
    }

    public <T> EasyApiBindSqlResult<T> queryListPage(String sql, Class<T> clazz, Integer currentPageParam, Integer showCountParam, Object ... params) {
        if (sql != null && !sql.trim().toUpperCase().startsWith("SELECT")) {
            throw new RuntimeException("\u5f53\u524d\u975e\u67e5\u8be2\u8bed\u53e5");
        }
        String countSql = "select count(1) from (" + sql + ") tmp";
        int totalResult = this.executeCount(this.executeSql(countSql, Arrays.asList(params))).intValue();
        EasyApiBindSqlResult easySqlResult = new EasyApiBindSqlResult();
        if (totalResult == 0) {
            return easySqlResult;
        }
        EasyapiBindPage page = new EasyapiBindPage();
        page.setShowCount(showCountParam);
        page.setCurrentPage(currentPageParam);
        page.setTotalResult(totalResult);
        page.setTotalPage((totalResult - 1) / page.getShowCount() + 1);
        Integer currentPage = page.getCurrentPage();
        Integer showCount = page.getShowCount();
        String limitSql = this.getListPageSql(sql, currentPage, showCount);
        List<Object> list = new ArrayList();
        List<Map<String, Object>> result = this.query(limitSql, params);
        if (result.size() > 0) {
            list = this.mapToBean(result, clazz);
            easySqlResult.setResultList(list);
            easySqlResult.setPage(page);
        }
        return easySqlResult;
    }

    public Map<String, Object> queryOne(String sql) {
        Object[] objs = new Object[]{};
        return this.queryOne(sql, objs);
    }

    public Map<String, Object> queryOne(String sql, Object ... params) {
        List<Map<String, Object>> list = this.query(sql = sql.toUpperCase().contains("LIMIT") ? sql.substring(0, sql.indexOf("limit")) + " limit 1" : sql + " limit 1", params);
        if (list != null && list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public <T> T queryOne(String sql, Class<T> clazz) {
        Object[] objs = new Object[]{};
        return this.queryOne(sql, clazz, objs);
    }

    public <T> T queryOne(String sql, Class<T> clazz, Object ... params) {
        List<T> list = this.query(sql = sql + " limit 1", clazz, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Map<String, Object>> query(String sql, Object ... params) {
        List<Object> list = Arrays.asList(params);
        List<Map<String, Object>> result = this.executeQuery(this.executeSql(sql, list));
        this.toCommit();
        if (result == null) {
            result = new ArrayList<Map<String, Object>>();
        }
        return result;
    }

    public List<Map<String, Object>> query(String sql) {
        Object[] objs = new Object[]{};
        return this.query(sql, objs);
    }

    public <T> List<T> query(String sql, Class<T> clazz) {
        Object[] objs = new Object[]{};
        return this.query(sql, clazz, objs);
    }

    public <T> List<T> customQuery(String sql, Class<T> clazz) {
        Object[] objs = new Object[]{};
        return this.customQuery(sql, clazz, objs);
    }

    public List<Map<String, Object>> customQuery(String sql) {
        Object[] objs = new Object[]{};
        return this.customQuery(sql, objs);
    }

    public List<Map<String, Object>> customQuery(String sql, Object ... params) {
        String uSql = sql.trim().toUpperCase();
        if (sql != null && !uSql.startsWith("SELECT") && !uSql.startsWith("CREATE")) {
            throw new RuntimeException("\u5f53\u524d\u975e\u67e5\u8be2\u8bed\u53e5");
        }
        List<Object> list = Arrays.asList(params);
        List<Map<String, Object>> result = this.executeQuery(this.executeSql(sql, list));
        this.toCommit();
        if (result == null) {
            result = new ArrayList<Map<String, Object>>();
        }
        return result;
    }

    public <T> List<T> customQuery(String sql, Class<T> clazz, Object ... params) {
        List<Object> list = Arrays.asList(params);
        List<Map<String, Object>> result = this.executeQuery(this.executeSql(sql, list));
        this.toCommit();
        if (result == null) {
            result = new ArrayList<Map<String, Object>>();
        }
        return this.mapToBean(result, clazz);
    }

    public <T> List<T> query(String sql, Class<T> clazz, Object ... params) {
        if (sql != null && !sql.trim().toUpperCase().startsWith("SELECT")) {
            throw new RuntimeException("\u5f53\u524d\u975e\u67e5\u8be2\u8bed\u53e5");
        }
        List<Object> list = Arrays.asList(params);
        List<Map<String, Object>> result = this.executeQuery(this.executeSql(sql, list));
        this.toCommit();
        if (result == null) {
            result = new ArrayList<Map<String, Object>>();
        }
        return this.mapToBean(result, clazz);
    }

    public int update(String sql, Object ... params) {
        if (sql != null && sql.trim().toUpperCase().startsWith("SELECT")) {
            throw new RuntimeException("\u5f53\u524d\u975e\u4fee\u6539\u8bed\u53e5");
        }
        List<Object> list = Arrays.asList(params);
        int count = this.executeUpdate(this.executeSql(sql, list));
        this.toCommit();
        return count;
    }

    public int update(String sql) {
        Object[] objs = new Object[]{};
        return this.update(sql, objs);
    }

    public <T> List<T> select(T obj) {
        return this.select(new EasyapiBindSQLExecuter(obj));
    }

    public <T> List<T> select(T obj, String orderByTfd, boolean desc) {
        return this.select(new EasyapiBindSQLExecuter(obj).orderBy(orderByTfd, desc));
    }

    public <T> T selectOne(T obj) {
        return this.selectOne(obj, null, false);
    }

    public <T> T selectOne(EasyapiBindSQLExecuter executer) {
        List<T> list = this.select(executer.setLimitStart(1));
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public <T> T selectOne(T obj, String orderByTfd, boolean desc) {
        EasyapiBindSQLExecuter executer = new EasyapiBindSQLExecuter(obj);
        if (orderByTfd != null) {
            executer.orderBy(orderByTfd, desc);
        }
        executer.setLimitStart(0);
        executer.setLimitSize(1);
        List<T> list = this.select(executer);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> select(EasyapiBindSQLExecuter executer) {
        if (executer.getBean() == null) {
            throw new RuntimeException("\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SqlStatement st = this.creatSelectSql(executer);
        List<Map<String, Object>> list = this.executeQuery(this.executeSql(st.getSql().toString(), st.getParams()));
        this.toCommit();
        if (list == null) {
            return new ArrayList();
        }
        Object obj = executer.getBean();
        List resulTs = this.mapToBean(list, obj);
        return resulTs;
    }

    public <T> Double selectCount(T obj) {
        return this.selectCount(new EasyapiBindSQLExecuter(obj));
    }

    public <T> Double selectCount(EasyapiBindSQLExecuter executer) {
        if (executer.getBean() == null) {
            throw new RuntimeException("\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object obj = executer.getBean();
        String Tne2 = this.getTne(obj);
        Map<String, Object> map = this.getAttributes(obj);
        String rule = executer.getReturnParam();
        if (rule == null || rule.length() == 0) {
            rule = " COUNT(1) ";
        }
        StringBuffer sql = new StringBuffer("select " + rule + " from " + Tne2 + " where 1=1 ");
        Set<Map.Entry<String, Object>> entry = map.entrySet();
        ArrayList<Object> params = new ArrayList<Object>();
        for (Map.Entry<String, Object> en : entry) {
            sql.append(" and " + en.getKey() + "=? ");
            params.add(en.getValue());
        }
        if (executer.getSql() != null && executer.getSql().length() > 0) {
            sql.append(executer.getSql());
            params.addAll(executer.getParams());
        }
        Double count = this.executeCount(this.executeSql(sql.toString(), params));
        this.toCommit();
        this.printLogger("==============================");
        this.printLogger("\u6267\u884c\u67e5\u8be2\u8bed\u53e5:" + sql.toString().replace("*", "count(1)"));
        this.printLogger("\u6267\u884c\u53c2\u6570\u4e3a:" + params);
        this.printLogger("==============================");
        return count;
    }

    private SqlStatement creatSelectSql(EasyapiBindSQLExecuter executer) {
        SqlStatement st = new SqlStatement();
        Object obj = executer.getBean();
        String Tne2 = this.getTne(obj);
        if (Tne2 == null) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u540d\u4e3a\u7a7a\uff0c\u6216\u65e0@Tne\u6ce8\u89e3");
        }
        Map<String, Object> attributes = this.getAttributes(obj);
        String returnParam = " * ";
        if (executer.getReturnParam() != null && executer.getReturnParam().length() > 0) {
            returnParam = executer.getReturnParam();
        }
        StringBuffer sql = new StringBuffer("select " + returnParam + " from " + Tne2 + " where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        for (String key : attributes.keySet()) {
            sql.append("and " + key + "=? ");
            params.add(attributes.get(key));
        }
        if (executer.getSql() != null) {
            sql.append(executer.getSql());
            params.addAll(executer.getParams());
        }
        if (executer.getLimitStart() != null && executer.getLimitStart() != 0) {
            sql.append(" limit " + executer.getLimitStart());
            if (executer.getLimitSize() != null && executer.getLimitSize() != 0) {
                sql.append("," + executer.getLimitSize());
            }
        }
        st.setParams(params);
        st.setSql(sql);
        return st;
    }

    public <T> EasyApiBindSqlResult<T> listPage(EasyapiBindSQLExecuter executer, Integer currentPageParam, Integer showCountParam) {
        EasyApiBindSqlResult easySqlResult = new EasyApiBindSqlResult();
        if (showCountParam <= 0) {
            throw new RuntimeException("\u6bcf\u9875\u663e\u793a\u6761\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        SqlStatement st = this.creatSelectSql(executer);
        int totalResult = this.executeCount(this.executeSql("select count(1) from (" + st.getSql().toString() + ") tmp", st.getParams())).intValue();
        if (totalResult == 0) {
            return easySqlResult;
        }
        EasyapiBindPage page = new EasyapiBindPage();
        page.setShowCount(showCountParam);
        page.setCurrentPage(currentPageParam);
        page.setTotalResult(totalResult);
        page.setTotalPage((totalResult - 1) / page.getShowCount() + 1);
        Integer currentPage = page.getCurrentPage();
        Integer showCount = page.getShowCount();
        String limitSql = this.getListPageSql(st.getSql().toString(), currentPage, showCount);
        List<?> list = this.query(limitSql, executer.getBean().getClass(), st.getParams().toArray());
        if (list.size() > 0) {
            easySqlResult.setResultList(list);
            easySqlResult.setPage(page);
        }
        return easySqlResult;
    }

    public <T> EasyApiBindSqlResult<T> listPage(T obj, Integer currentPageParam, Integer showCountParam, String orderByTfd, boolean desc) {
        return this.listPage((T)new EasyapiBindSQLExecuter(obj).orderBy(orderByTfd, desc), currentPageParam, showCountParam);
    }

    public <T> EasyApiBindSqlResult<T> listPage(T obj, Integer currentPageParam, Integer showCountParam) {
        return this.listPage((T)new EasyapiBindSQLExecuter(obj), currentPageParam, showCountParam);
    }

    private String getListPageSql(String sql, int currentPage, int showCount) {
        StringBuffer pageSql = new StringBuffer();
        if ("ORACLE".equals(this.driver)) {
            pageSql.append("select * from (select tmp_tb.*,ROWNUM row_id from (");
            pageSql.append(sql);
            pageSql.append(") as tmp_tb where ROWNUM<=");
            pageSql.append((currentPage - 1) * showCount + showCount);
            pageSql.append(") where row_id>");
            pageSql.append((currentPage - 1) * showCount);
        } else if ("MYSQL".equalsIgnoreCase(this.driver)) {
            pageSql.append(sql);
            pageSql.append(" limit ").append((currentPage - 1) * showCount).append(",").append(showCount);
        }
        return pageSql.toString();
    }

    public <T> void insert(Collection<T> objs) {
        String Tne2;
        if (objs == null || objs.size() == 0) {
            throw new RuntimeException("\u8981\u63d2\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Iterator<T> it = objs.iterator();
        T obj = null;
        if (it.hasNext()) {
            obj = it.next();
        }
        if ((Tne2 = this.getTne(obj)) == null) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u540d\u4e3a\u7a7a\uff0c\u6216\u65e0@Tne\u6ce8\u89e3");
        }
        Map<String, Object> attributes = this.getAttributes(obj);
        if (attributes == null || attributes.isEmpty()) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u4e0d\u5141\u8bb8\u6dfb\u52a0\u7a7a\u6570\u636e");
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        Set<String> keys = attributes.keySet();
        sql.append("insert into " + Tne2 + " (");
        for (String string : keys) {
            sql.append("`" + string + "` ,");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" )values");
        Iterator<T> iterator = objs.iterator();
        while (iterator.hasNext()) {
            sql.append("( ");
            for (String key : keys) {
                sql.append(" ?,");
            }
            Map<String, Object> map = this.getAttributes(iterator.next());
            for (String key : keys) {
                params.add(map.get(key));
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(" ),");
        }
        sql.delete(sql.length() - 1, sql.length());
        this.executeInsert(sql.toString(), params);
        this.toCommit();
    }

    public <T> T insert(T obj) {
        Map<String, Object> attributes;
        if (this.getTidValue(obj) != null) {
            throw new RuntimeException("\u4e3b\u952e:" + this.getTidName(obj) + "\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u53c2\u6570");
        }
        String Tne2 = this.getTne(obj);
        if (Tne2 == null) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u540d\u4e3a\u7a7a\uff0c\u6216\u65e0@Tne\u6ce8\u89e3");
        }
        if (BaseDbEntity.class.isAssignableFrom(obj.getClass())) {
            BaseDbEntity b = (BaseDbEntity)obj;
            b.setCreateTime(System.currentTimeMillis());
            b.setDeleted(0);
        }
        if ((attributes = this.getAttributes(obj)) == null || attributes.isEmpty()) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u4e0d\u5141\u8bb8\u6dfb\u52a0\u7a7a\u6570\u636e");
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("insert into " + Tne2 + " (");
        for (String key : attributes.keySet()) {
            sql.append("`" + key + "` ,");
            params.add(attributes.get(key));
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" )values( ");
        for (String key : attributes.keySet()) {
            sql.append(" ?,");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(" )");
        Object id = this.executeInsert(sql.toString(), params);
        this.toCommit();
        String TidName = this.getTidJavaName(obj);
        try {
            if (TidName == null) {
                this.printLogger("\u6570\u636e\u63d2\u5165\u6210\u529f,\u4f46\u672a\u627e\u5230@Tid \u6ce8\u89e3,\u65e0\u6cd5\u5c06\u4e3b\u952e\u8fd4\u56de");
                return obj;
            }
            this.setAttribute(obj, TidName, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    private void setAttribute(Object obj, String attrName, Object value) {
        try {
            Class<?> clazz = obj.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Field f = clazz.getDeclaredField(attrName);
                    if (f == null) continue;
                    f.setAccessible(true);
                    if (value == null || f.getType().isAssignableFrom(value.getClass())) {
                        f.set(obj, value);
                    } else {
                        f.set(obj, this.parseToObject(value, f.getType()));
                    }
                    f.setAccessible(false);
                    return;
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T parseToObject(Object value, Class<T> type) {
        Object result = null;
        if (value == null || type == String.class) {
            result = value == null ? null : value.toString();
        } else if (type == Character.class || type == Character.TYPE) {
            char[] chars = value.toString().toCharArray();
            result = chars.length > 0 ? (chars.length > 1 ? (Object)chars : Character.valueOf(chars[0])) : Character.valueOf('\u0000');
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            result = Boolean.parseBoolean(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            result = value.toString().equalsIgnoreCase("true") ? Boolean.valueOf(true) : (value.toString().equalsIgnoreCase("false") ? Boolean.valueOf(false) : value);
        } else if (type == Long.class || type == Long.TYPE) {
            result = Long.parseLong(value.toString());
        } else if (type == Integer.class || type == Integer.TYPE) {
            result = Integer.parseInt(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            result = Double.parseDouble(value.toString());
        } else if (type == Float.class || type == Float.TYPE) {
            result = Float.valueOf(Float.parseFloat(value.toString()));
        } else if (type == Byte.class || type == Byte.TYPE) {
            result = Byte.parseByte(value.toString());
        } else if (type == Short.class || type == Short.TYPE) {
            result = Short.parseShort(value.toString());
        }
        return (T)result;
    }

    public <T> Integer update(EasyapiBindSQLExecuter executer) {
        Object obj = executer.getBean();
        if (obj == null) {
            throw new RuntimeException("\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String Tne2 = this.getTne(obj);
        if (Tne2 == null) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868\u540d\u4e3a\u7a7a\uff0c\u6216\u65e0@Tne\u6ce8\u89e3");
        }
        Object TidValue = null;
        String param_id = this.getTidName(obj);
        if (param_id != null) {
            TidValue = this.getTidValue(obj);
        }
        if (TidValue == null && executer.getSql() == null) {
            throw new RuntimeException("\u4e3b\u952e\u503c\u4e3a\u7a7a\uff0c\u6216\u65e0@Tid\u6ce8\u89e3");
        }
        Map<String, Object> attributes = this.getAttributes(obj);
        attributes.remove(param_id);
        if (attributes == null || attributes.isEmpty()) {
            throw new RuntimeException("\u53c2\u6570\u5c5e\u6027\u4e3a\u7a7a");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update " + Tne2 + " set ");
        for (String key : attributes.keySet()) {
            sql.append("`" + key + "` = ? ,");
        }
        if (!executer.getIncrMap().isEmpty()) {
            Map<String, Object> incrMap = executer.getIncrMap();
            Iterator<String> set = incrMap.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                sql.append("`" + entry.getKey() + "` = `" + entry.getKey() + "+`" + entry.getValue() + ",");
            }
        }
        if (!executer.getNullValFields().isEmpty()) {
            List<String> nullVal = executer.getNullValFields();
            for (String field : nullVal) {
                sql.append("`" + field + "` = NULL,");
            }
        }
        sql.delete(sql.length() - 1, sql.length());
        ArrayList<Object> params = new ArrayList<Object>();
        for (String key : attributes.keySet()) {
            params.add(attributes.get(key));
        }
        if (executer.getSql() != null) {
            sql.append(" where 1=1 ").append(executer.getSql());
            params.addAll(executer.getParams());
            if (param_id != null && TidValue != null) {
                sql.append(" and " + param_id + " = ?");
                params.add(TidValue);
            }
        } else {
            sql.append(" where " + param_id + " = ?");
            params.add(TidValue);
        }
        int num = this.update(sql.toString(), params.toArray());
        return num;
    }

    public <T> Integer update(T obj) {
        if (obj instanceof BaseDbEntity) {
            BaseDbEntity b = (BaseDbEntity)obj;
            b.setUpdateTime(System.currentTimeMillis());
        }
        return this.update(new EasyapiBindSQLExecuter(obj));
    }

    public <T> Integer delete(EasyapiBindSQLExecuter executer) {
        Object obj = executer.getBean();
        String Tne2 = this.getTne(obj);
        if (Tne2 == null) {
            return null;
        }
        Map<String, Object> attributes = this.getAttributes(obj);
        if (executer.getSql() == null && (attributes == null || attributes.isEmpty())) {
            throw new RuntimeException("\u5c5e\u6027\u4e3a\u7a7a,\u6682\u4e0d\u5141\u8bb8\u5220\u9664\u5168\u8868\u6570\u636e");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + Tne2 + " where 1=1 ");
        for (String string : attributes.keySet()) {
            sql.append("and " + string + " =? ");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        for (String key : attributes.keySet()) {
            params.add(attributes.get(key));
        }
        if (executer.getSql() != null) {
            sql.append(executer.getSql());
            params.addAll(executer.getParams());
        }
        int n = this.update(sql.toString(), params.toArray());
        return n;
    }

    public <T> Integer delete(T obj) {
        return this.delete(new EasyapiBindSQLExecuter(obj));
    }

    private <T> String getTne(T t) {
        Class<?> tClass = t.getClass();
        String Tne2 = "";
        Map<String, Tne> map = EasyapiBindSqlExecution.getClassAnnotation(tClass, Tne.class);
        Tne annotation = null;
        if (map != null && !map.isEmpty()) {
            annotation = map.get(tClass.getName());
        }
        if (annotation != null) {
            if (!annotation.name().equals("")) {
                Tne2 = annotation.name();
            }
            if (!annotation.value().equals("")) {
                Tne2 = annotation.value();
            }
            if (!Tne2.equals("")) {
                return Tne2;
            }
        }
        return null;
    }

    private <T> String getTidName(Object t) {
        String Tid2 = null;
        Class<?> clazz = t.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                Tid annotation = f.getDeclaredAnnotation(Tid.class);
                Tfd Tfd2 = f.getDeclaredAnnotation(Tfd.class);
                if (annotation != null) {
                    if (Tfd2 != null) {
                        if (!Tfd2.name().equals("")) {
                            Tid2 = Tfd2.name();
                        } else if (!Tfd2.value().equals("")) {
                            Tid2 = Tfd2.value();
                        }
                    } else {
                        Tid2 = f.getName();
                    }
                }
                if (Tid2 == null) continue;
                return Tid2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private <T> Object getTidValue(Object t) {
        Class<?> clazz = t.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                Tid annotation = f.getDeclaredAnnotation(Tid.class);
                if (annotation == null) continue;
                f.setAccessible(true);
                try {
                    return f.get(t);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private <T> String getTidJavaName(Object t) {
        Class<?> clazz = t.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                Tid annotation = f.getDeclaredAnnotation(Tid.class);
                if (annotation == null) continue;
                return f.getName();
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private Map<String, Object> getAttributes(Object bean) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean changeTid = false;
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    f.setAccessible(true);
                    if (f.get(bean) == null || changeTid && f.getName().equals("id")) {
                        f.setAccessible(false);
                        continue;
                    }
                    Tie tie = f.getDeclaredAnnotation(Tie.class);
                    if (tie != null) continue;
                    Tid tid = f.getDeclaredAnnotation(Tid.class);
                    Tfd tfd = f.getDeclaredAnnotation(Tfd.class);
                    if (tid != null && tfd != null && !tfd.name().equals("")) {
                        changeTid = true;
                    }
                    if (tfd != null) {
                        String TfdName = "";
                        if (!tfd.name().equals("")) {
                            TfdName = tfd.name();
                        }
                        if (!tfd.value().equals("")) {
                            TfdName = tfd.value();
                        }
                        if (TfdName.equals("")) continue;
                        f.setAccessible(true);
                        Object o = f.get(bean);
                        if (tfd.type().equals(Blob.class)) {
                            o = o.toString().getBytes();
                        }
                        map.put(TfdName, o);
                        f.setAccessible(false);
                        continue;
                    }
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    if (value == null) continue;
                    map.put(f.getName(), value);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printLogger(boolean doLogger) {
        this.doLogger = doLogger;
    }

    private void printLogger(String message) {
        if (this.doLogger) {
            // empty if block
        }
    }

    public void setOracleDriver() {
        this.driver = "ORACLE";
    }

    private boolean isBaseClass(Class value) {
        if (value == null) {
            return true;
        }
        if (value.equals(Long.class)) {
            return true;
        }
        if (value.equals(Integer.class)) {
            return true;
        }
        if (value.equals(Double.class)) {
            return true;
        }
        if (value.equals(Float.class)) {
            return true;
        }
        if (value.equals(Byte.class)) {
            return true;
        }
        if (value.equals(Boolean.class)) {
            return true;
        }
        if (value.equals(Short.class)) {
            return true;
        }
        if (value.equals(Character.class)) {
            return true;
        }
        return value.equals(String.class);
    }

    private <T> List<T> mapToBean(List<Map<String, Object>> list, T obj) {
        ArrayList resulTs = new ArrayList();
        try {
            for (Map<String, Object> temp : list) {
                Object t = obj.getClass().newInstance();
                Class<?> clazz = t.getClass();
                while (!clazz.equals(Object.class)) {
                    Field[] fields;
                    for (Field f : fields = clazz.getDeclaredFields()) {
                        Tfd Tfd2 = f.getDeclaredAnnotation(Tfd.class);
                        try {
                            if (Tfd2 != null) {
                                Object value;
                                String TfdName = "";
                                if (!Tfd2.name().equals("")) {
                                    TfdName = Tfd2.name();
                                }
                                if (!Tfd2.value().equals("")) {
                                    TfdName = Tfd2.value();
                                }
                                if (TfdName.equals("") || (value = temp.get(TfdName)) == null) continue;
                                if (Blob.class.isAssignableFrom(value.getClass())) {
                                    value = ClobUtil.getBlob((Blob)value);
                                }
                                if (Clob.class.isAssignableFrom(value.getClass())) {
                                    value = ClobUtil.getStr((Clob)value);
                                }
                                if (Tfd2.type().equals(Blob.class) && value.getClass().equals(byte[].class)) {
                                    value = new String((byte[])value);
                                }
                                f.setAccessible(true);
                                f.set(t, value);
                                f.setAccessible(false);
                            }
                            if (temp.get(f.getName()) == null) continue;
                            f.setAccessible(true);
                            f.set(t, temp.get(f.getName()));
                            f.setAccessible(false);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("\u7c7b\u5c5e\u6027" + f.getName() + "\u4e0e\u8868\u5b57\u6bb5\u7c7b\u578b\u4e0d\u7b26", e);
                        }
                    }
                    clazz = clazz.getSuperclass();
                }
                resulTs.add(t);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resulTs;
    }

    public static <T> Map<String, T> getClassAnnotation(Class clazz, Class<T> annotation) {
        HashMap<String, Annotation> map = new HashMap<String, Annotation>();
        Class cl = clazz;
        while (!cl.equals(Object.class)) {
            Annotation[] ans;
            for (Annotation an : ans = cl.getDeclaredAnnotations()) {
                if (!an.annotationType().equals(annotation)) continue;
                Annotation t = an;
                map.put(cl.getName(), t);
            }
            cl = cl.getSuperclass();
        }
        return map;
    }

    public <T> List<T> mapToBean(List<Map<String, Object>> list, Class<T> clazz) {
        try {
            if (list.size() == 0) {
                return new ArrayList();
            }
            if (this.isBaseClass(clazz) && list.size() > 0 && list.get(0).size() == 1) {
                ArrayList<Object> result = new ArrayList<Object>();
                Object value = null;
                String mapKey = null;
                Iterator<Object> iterator = list.get(0).keySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    mapKey = string = iterator.next();
                    value = list.get(0).get(string);
                }
                for (Map map : list) {
                    value = map.get(mapKey);
                    result.add(value);
                }
                return result;
            }
            if (clazz.equals(Map.class)) {
                return list;
            }
            T t = clazz.newInstance();
            return this.mapToBean(list, t);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class SqlStatement {
        private StringBuffer sql;
        private List<Object> params;

        SqlStatement() {
        }

        public StringBuffer getSql() {
            return this.sql;
        }

        public void setSql(StringBuffer sql) {
            this.sql = sql;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }
    }
}

