package cn.easyutil.easyapi.util;

import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobUtil {

    /**
     * 获取字符串
     * @param clob  clob对象
     */
    public static String getStr(Clob clob){
        if(clob == null){
            return null;
        }
        try {
            Long length = clob.length();
            return clob.getSubString(1,length.intValue());
        } catch (SQLException throwables) {
            throwables.printStackTrace();
            throw new RuntimeException(throwables);
        }
    }

    /**
     * 获取字符串
     * @param blob  clob对象
     */
    public static String getBlob(Blob blob){
        if(blob == null){
            return null;
        }
        try {
            return new String(blob.getBytes(1, (int) blob.length()), Charset.forName("UTF-8"));
        } catch (SQLException throwables) {
            throwables.printStackTrace();
            throw new RuntimeException(throwables);
        }
    }
}
