package cn.easyutil.easyapi.service;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;

public class InterfaceService extends DBService<DBModuleInterfaceEntity>{

    @Resource(name = "easyapiTestService")
    private TestService testService;

    @Resource(name = "easyapiTestInfoService")
    private TestInfoService testInfoService;

    @Resource(name = "easyapiTestGroupService")
    private TestGroupService testGroupService;

    @Resource(name = "easyapiInterfaceParamService")
    private InterfaceParamService parameterService;

    public void delByIds(Collection ids){
        if(ids==null || ids.isEmpty()){
            return ;
        }
        //删除接口
        delete(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).in(DBModuleInterfaceEntity::getId, ids));
        //删除接口测试三类
        testService.delete(EasyapiBindSQLExecuter.build(new DBComplexTestEntity()).in(DBComplexTestEntity::getInterfaceId, ids));
        testInfoService.delete(EasyapiBindSQLExecuter.build(new DBComplexTestInfoEntity()).in(DBComplexTestInfoEntity::getInterfaceId, ids));
        testGroupService.delete(EasyapiBindSQLExecuter.build(new DBComplexTestGroupEntity()).in(DBComplexTestGroupEntity::getInterfaceId, ids));
        //删除接口参数
        parameterService.delete(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).in(DBInterfaceParamEntity::getInterfaceId, ids));
    }

    @Override
    public void insert(DBModuleInterfaceEntity entity) {
        entity.createOrigin();
        super.insert(entity);
    }
}
