package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.*;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.model.*;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.*;
import cn.easyutil.easyapi.test.TestController;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

import java.io.File;
import java.lang.reflect.Method;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DocCreate {

    /**
     * 项目配置文件
     */

    private AllConfiguration all;

    private ApplicationContext appContext;

    private EasyapiBindSqlExecution execution;

    public DocCreate(AllConfiguration all, ApplicationContext appContext, EasyapiBindSqlExecution execution){
        this.all = all;
        this.appContext = appContext;
        this.execution = execution;
    }

    public void createApi() {
        EasyapiConfiguration configuration = ProjectContext.allConfiguration.getConfiguration();
        Set<Class> set = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().readControllers(appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        if(configuration.isRenewDoc()){
            //更新现有文档，把当前文档全部改成待更新
            DBModuleInterfaceEntity upgrade = new DBModuleInterfaceEntity();
            upgrade.setUpgradeStatus(1);
            execution.update(EasyapiBindSQLExecuter.build(upgrade).eq(DBModuleInterfaceEntity::getProjectId,ProjectContext.currentProjectId));
        }
        Iterator<Class> iterator = set.iterator();
        //解析全部接口
        while (iterator.hasNext()) {
            Class aClass = iterator.next();
            //已生成的接口
            DocClassBean api = createControllerApi(aClass);
            DBModuleControllerEntity controllerBean = api.getController();
            if(controllerBean == null){
                continue;
            }
            //如果数据库中不存在则添加到数据库
            DBModuleControllerEntity queryController = execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity())
                    .eq(DBModuleControllerEntity::getProjectId, controllerBean.getProjectId())
                    .eq(DBModuleControllerEntity::getModuleId, controllerBean.getModuleId())
                    .eq(DBModuleControllerEntity::getClassName, controllerBean.getClassName())
            );
            if(queryController == null){
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                execution.insert(controllerBean);
                queryController = controllerBean;
            }else{
                Long id = queryController.getId();
                BeanUtils.copyProperties(controllerBean,queryController);
                queryController.setId(id);
                execution.update(queryController);
            }

            //处理接口
            List<DocInterfaceBean> interfaces = api.getInterfaces();
            if(interfaces==null || interfaces.isEmpty()){
                continue;
            }
            // 存放interface列表的文件内容
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setModuleId(ProjectContext.currentModuleId);
            queryInterface.setControllerId(queryController.getId());
            List<DBModuleInterfaceEntity> apiInterfaceBeans = execution.select(queryInterface);
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList<>();
            }
            //数据库里已存在的当前controller下的接口集合
            Map<String,DBModuleInterfaceEntity> allExistInterface = apiInterfaceBeans.stream().collect(Collectors.toMap(DBModuleInterfaceEntity::getUnique, Function.identity()));
            for (DocInterfaceBean itf : interfaces) {
                //接口详情
                DBModuleInterfaceEntity interfaceBean = itf.getInterfaceBean();
                //接口参数相关
                DBInterfaceParamEntity requestParam = itf.getRequestParam();
                //如果数据库中已存在该接口，则不进行处理
                DBModuleInterfaceEntity dbFindInterface = allExistInterface.get(interfaceBean.getUnique());
                if(dbFindInterface!=null && !dbFindInterface.getShow().equals(interfaceBean.getShow())){
                    dbFindInterface.setShow(interfaceBean.getShow());
                    execution.update(dbFindInterface);
                }
                if(dbFindInterface!=null && dbFindInterface.getUpgradeStatus()==0){
                    continue;
                }
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setModuleId(queryController.getModuleId());
                interfaceBean.setProjectId(queryController.getProjectId());
                if(dbFindInterface != null){
                    interfaceBean.setId(dbFindInterface.getId());
                    interfaceBean.setUpgradeStatus(0);
                    if(interfaceBean.getRenewType().equals(RenewType.skip.getType())){
                        continue;
                    }
                    if(interfaceBean.getRenewType().equals(RenewType.increment.getType())){
                        interfaceBean.mergin(dbFindInterface);
                    }
                    if(StringUtil.isEmpty(dbFindInterface.getOrigin())){
                        interfaceBean.createOrigin();
                    }else{
                        interfaceBean.setOrigin(dbFindInterface.getOrigin());
                    }
                    execution.update(interfaceBean);
                }else{
                    execution.insert(interfaceBean);
                }
                allExistInterface.put(interfaceBean.getUnique(),interfaceBean);
                //处理接口参数
                EasyapiBindSQLExecuter executer = EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, interfaceBean.getId());
                DBInterfaceParamEntity old = execution.selectOne(executer);
                requestParam.setInterfaceId(interfaceBean.getId());
                requestParam.setProjectId(interfaceBean.getProjectId());
                if(old == null){
                    //之前不存在接口参数，直接添加到库
                    execution.insert(requestParam);
                    continue;
                }
                //处理已经存在的参数
                if(!StringUtil.isEmpty(requestParam.getRequestParamJson())){
                    if(!StringUtil.isEmpty(old.getRequestParamJson())){
                        List<DocParamEntity> oldParams = JsonUtil.jsonToList(old.getRequestParamJson(), DocParamEntity.class);
                        List<DocParamEntity> nowParams = JsonUtil.jsonToList(requestParam.getRequestParamJson(), DocParamEntity.class);
                        paramsMergin(nowParams,oldParams.stream().collect(Collectors.toMap(DocParamEntity::getUnique,Function.identity())));
                        requestParam.setRequestParamJson(JsonUtil.beanToJson(nowParams));
                    }
                }
                if(!StringUtil.isEmpty(requestParam.getResponseParamJson())){
                    if(!StringUtil.isEmpty(old.getResponseParamJson())){
                        List<DocParamEntity> oldParams = JsonUtil.jsonToList(old.getResponseParamJson(), DocParamEntity.class);
                        List<DocParamEntity> nowParams = JsonUtil.jsonToList(requestParam.getResponseParamJson(), DocParamEntity.class);
                        paramsMergin(nowParams,oldParams.stream().collect(Collectors.toMap(DocParamEntity::getUnique,Function.identity())));
                        requestParam.setResponseParamJson(JsonUtil.beanToJson(nowParams));
                    }
                }
                requestParam.setId(old.getId());
                execution.update(requestParam);
            }
        }
    }

    private void paramsMergin(List<DocParamEntity> now,Map<String,DocParamEntity> old){
        if(now==null || now.isEmpty()){
            return ;
        }
        for (DocParamEntity nowParam : now) {
            DocParamEntity oldParam = old.get(nowParam.getUnique());
            if(oldParam!=null && !StringUtil.isEmpty(oldParam.getOrigin())){
                DocParamEntity origin = JsonUtil.jsonToBean(oldParam.getOrigin(),DocParamEntity.class);
                paramsMergin(nowParam,oldParam,origin);
                nowParam.setOrigin(JsonUtil.beanToJson(origin));
            }
            if(nowParam.getChildren()!=null && !nowParam.getChildren().isEmpty()){
                paramsMergin(nowParam.getChildren(),old);
            }
        }
    }

    private void paramsMergin(DocParamEntity now,DocParamEntity old,DocParamEntity origin){
        if(now.getRenewType().equals(RenewType.skip.getType())){
            BeanUtils.copyProperties(old,now);
            return ;
        }
        if(now.getRenewType().equals(RenewType.overwrite.getType())){
            return ;
        }
        EasyapiOriginUtil.mergin(now,old,origin);
    }

    public DocClassBean createControllerApi(Class aClass){
        String canonicalName = aClass.getCanonicalName();
        //获取controller源文件路径
        String controllerPath = ProjectContext.projectBasePath + File.separator
                + aClass.getCanonicalName().replace(".", File.separator) + ".java";
        //读取controller源文件
        JavaSourceReader controllerSourceReader = JavaSourceReader.builder(new File(controllerPath));
        //组装基础参考信息，包过当前类、方法、类注释、方法注释等等
        ApiExtra extra = new ApiExtra();
        extra.setControllerClass(aClass);
        extra.setControllerComment(controllerSourceReader.getComment());
        //如果设置了扫描包并且当前类不属于该包，则忽略该类
        if (!StringUtil.isEmpty(all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(all.getConfiguration().getScanPackage())) {
            return DocClassBean.EMPTY;
        }
        //如果设置了忽略则跳过
        if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().ignore(aClass,extra)) {
            return DocClassBean.EMPTY;
        }
        //方法最终返回
        DocClassBean result = new DocClassBean();

        //构建controller
        DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass)
                .setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter())
                .setExtra(extra)
                .buildController();
        controllerBean.setProjectId(ProjectContext.currentProjectId);
        controllerBean.setModuleId(ProjectContext.currentModuleId);

        result.setController(controllerBean);
        extra.setDbController(controllerBean);

        //获取全部接口方法
        List<Method> methods = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().readAllInterfaces(aClass,extra);

        //==================以下采取新的读法
        List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
        Map<String, Map<String, String>> readMethodParamComment = new HashMap<>();
        for (MethodComment comment : methodComment) {
            List<SourceParameterComment> parameters = comment.getParameters();
            Map<String, String> map = new HashMap<>();
            for (SourceParameterComment parameter : parameters) {
                map.put(parameter.getName(), parameter.getComment());
            }
            readMethodParamComment.put(comment.getName(), map);
        }
        //==================

        for (Method method : methods) {
            //如果接口设置忽略则跳过
            if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().ignore(method,extra)) {
                continue;
            }

            MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
            extra.setMethod(method);
            extra.setMethodComment(methodSourceComment);
            //构建接口
            DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method)
                    .setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter())
                    .setApiExtra(extra)
                    .buildInterface();
            interfaceBean.setProjectId(controllerBean.getProjectId());
            interfaceBean.setModuleId(controllerBean.getModuleId());
            interfaceBean.setControllerClass(controllerBean.getClassName());
            interfaceBean.setControllerId(controllerBean.getId());
            extra.setDbInterface(interfaceBean);
            List<String> customSearch = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().customSearch(method, extra);
            interfaceBean.setCustomTags(customSearch==null?"":String.join(",",customSearch));
            if(!StringUtil.isEmpty(interfaceBean.getCustomTags()) && interfaceBean.getCustomTags().length()>150){
                interfaceBean.setCustomTags(interfaceBean.getCustomTags().substring(0,150));
            }
            interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(interfaceBean));
            DocInterfaceBean docInterfaceBean = new DocInterfaceBean();
            docInterfaceBean.setInterfaceBean(interfaceBean);

            //构建方法的请求、响应及mock参数
            MethodParamsCreator methodParamsCreator = MethodParamsCreator.build(aClass, method)
                    .withBeanCreator(JavaBeanCreator.builder(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter(),ProjectContext.projectBasePath,ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter(),extra))
                    .withMockFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter())
                    .withReqFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadRequestParamApiFilter())
                    .withResFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadResponseParamApiFilter())
                    .withBeanFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter())
                    .withExtra(extra)
                    .create();

            //将参数存储数据库
            String requestParams = JsonUtil.beanToJson(methodParamsCreator.getRequestParameters());
            DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setInterfaceId(interfaceBean.getId());
            reqPram.setCreateTime(System.currentTimeMillis());
            reqPram.setUpdateTime(System.currentTimeMillis());
            reqPram.setRequestParamJson(requestParams);
            reqPram.setResponseParamJson(JsonUtil.beanToJson(methodParamsCreator.getReturnParameter()));
            reqPram.setResponseMock(methodParamsCreator.getResponseMock());
            reqPram.setRequestMock(methodParamsCreator.getRequestMock());
            docInterfaceBean.setRequestParam(reqPram);
            result.getInterfaces().add(docInterfaceBean);
        }
        return result;
    }

    public static void main(String[] args) {
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(new EasyapiConfiguration());
        all.setDataConfiguration(new EasyapiDataConfiguration());
        all.setFilterClassConfiguration(new EasyapiFilterConfiguration());
        all.setFilterBeanConfiguration(new EasyapiFilterBeanConfiguration());
        all.setSyncRemoteConfiguration(new EasyapiSyncRemoteConfiguration());
        all.setUnitConfiguration(new EasyapiUnitConfiguration());
        all.setUserConfiguration(new EasyapiUserConfiguration());
        EasyapiFilterBeanConfiguration beanFilter = all.getFilterBeanConfiguration();
        beanFilter.setReadBeanApiFilter(new DefaultReadJavaBeanApi());
        beanFilter.setReadControllerApiFilter(new DefaultReadControllerApi());
        beanFilter.setReadInterfaceApiFilter(new DefaultReadInterfaceApi());
        beanFilter.setReadMockTemplateFilter(new DefaultReadMockTemplate());
        beanFilter.setReadRequestParamApiFilter(new DefaultReadRequestParamApi());
        beanFilter.setReadResponseParamApiFilter(new DefaultReadResponseParamApi());
        ProjectContext.allConfiguration = all;
        ProjectContext.projectBasePath = "D:\\self\\easyapi\\easyapi\\src\\main\\java";
        DocCreate create = new DocCreate(all,null,null);
        DocClassBean doc = create.createControllerApi(TestController.class);
        //添加标识
        Pattern pvalue = Pattern.compile("\"className\":\"(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{0,}\"");
        String context = JsonUtil.beanToJson(doc.getInterfaces().get(0).getRequestParam());
        Matcher matcher = pvalue.matcher(context);
        while (matcher.find()) {
            String group = matcher.group();
            while (context.contains(group)) {
                context = context.replaceFirst(group,
                        "\"className\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
            }
        }
        System.out.println(doc.getInterfaces());
    }
}
