package cn.easyutil.easyapi.logic.js;

public class ParseVariablesFactory {

    private static final MD5ParseVariables mD5ParseVariables = new MD5ParseVariables();
    private static final Base64ParseVariables base64ParseVariables = new Base64ParseVariables();
    private static final AESParseVariables aesParseVariables = new AESParseVariables();
    private static final DefaultParseVariables defaultParseVariables = new DefaultParseVariables();
    private static final JsonParseVariables jsonParseVariables = new JsonParseVariables();
    private static final OverwriteParseVariables overwriteParseVariables = new OverwriteParseVariables();

    public static ParseVariables get(String name){
        switch (name){
            case "md5":{
                return mD5ParseVariables;
            }
            case "base64":{
                return base64ParseVariables;
            }
            case "aes":{
                return aesParseVariables;
            }
            case "json":{
                return jsonParseVariables;
            }
            case "overwrite":{
                return overwriteParseVariables;
            }
        }
        return defaultParseVariables;
    }
}
