package cn.easyutil.easyapi.logic.js;

import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.entity.ScriptParamBean;
import cn.easyutil.easyapi.interview.entity.ScriptSourceBean;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JavaScriptExec {

    public static String getVal(Object source, String script){
        if(StringUtil.isEmpty(script)){
            return null;
        }
        String doScript = "function getVal($http){return $_script;}";
        doScript = doScript.replace("$_script",script);
        // 调用方法，此处无参数列表
        Object result = doSimpleScript("getVal",doScript,"脚本处理失败:"+script,source);
        if(result == null){
            return null;
        }
        if(ObjectUtil.isBaseObject(result)){
            return result.toString();
        }
        return JsonUtil.beanToJson(result);
    }

    /**
     * 执行脚本
     * @param function  脚本方法
     * @param errMsg    错误提示
     * @param params    方法参数
     * @return  执行结果
     */
    public static Object doSimpleScript(String functionName,String function,String errMsg,Object...params){
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            engine.eval(function);
            // 可有调用方法
            Invocable invoke = (Invocable) engine;
            // 调用方法，此处无参数列表
            return invoke.invokeFunction(functionName, params);
        }catch (Exception e) {
            throw new ApidocException(errMsg+","+e.getMessage());
        }
    }

    public static void doReplaceParams(Object source, String script){
        if(StringUtil.isEmpty(script)){
            return ;
        }
        //再将需要被替换的值替换成特定字符
        String doScript = "function replaceVal($http){$_script='$_replace_val_'}";
        doScript = doScript.replace("$_script",script);
        doSimpleScript("replaceVal",doScript, "参数替换失败," + script, source);
    }

    /**
     * 参数转换
     * @param source
     * @param scriptEntity
     * @return
     */
    public static ScriptSourceBean parseParams(ScriptSourceBean source, DBModuleScriptEntity scriptEntity){
        String script = scriptEntity.getScript();
        String parseKey = scriptEntity.getParseKey();
        String parseType = Optional.ofNullable(scriptEntity.getParseType()).orElse("encode");
        ParseVariables parseVariables = ParseVariablesFactory.get(scriptEntity.getValName());
        String replaceVal = getVal(source, script);
        if(replaceVal == null){
            return source;
        }
        try {
            doReplaceParams(source, script);
        }catch (Exception ignored) {}

        if(parseVariables instanceof OverwriteParseVariables && !StringUtil.isEmpty(parseKey)){
            try {
                doReplaceParams(source, parseKey);
            }catch (Exception e) {
                replaceVal = getVal(source,parseKey);
            }
        }
        boolean encode = parseType.trim().toLowerCase().equals("encode");
        String parseParam =  encode?parseVariables.encode(replaceVal,parseKey):parseVariables.decode(replaceVal,parseKey);
        String result = JsonUtil.beanToJson(source).replace("$_replace_val_", parseParam);
        return JsonUtil.jsonToBean(result,ScriptSourceBean.class);
    }

    public static void main(String[] args) {
        ScriptSourceBean source = new ScriptSourceBean();
        ScriptParamBean request = new ScriptParamBean();
        request.setCode(100);
        Map<String,String> reqHeaders = new HashMap<>();
        reqHeaders.put("auth","123");
        reqHeaders.put("cookie","coooo");
        request.setHeader(reqHeaders);
        Map<String,Object> reqData = new HashMap<>();
        reqData.put("name","xming");
        reqData.put("age",1000);
        DBUserEntity user = new DBUserEntity();
        user.setAccount("admin");
        user.setPassword("123456");
        reqData.put("user",user);
        request.setData(reqData);

        ScriptParamBean response = new ScriptParamBean();
        response.setCode(200);
        Map<String,String> resHeaders = new HashMap<>();
        resHeaders.put("userSession","coooo");
        resHeaders.put("ip","0.0.0.1");
        response.setHeader(resHeaders);
        Map<String,Object> resData = new HashMap<>();
        resData.put("mid",110);
        resData.put("mname","model");
        DBModuleEntity module = new DBModuleEntity();
        module.setName("test-module");
        module.setProjectId(1000L);
        resData.put("module",module);
        response.setData(resData);

        source.setReq(request);
        source.setRes(response);

        DBModuleScriptEntity scriptEntity = new DBModuleScriptEntity();
        scriptEntity.setCondition("$http.req.data.user.account == 'admin' && $http.req.header.auth == '123'");
        scriptEntity.setScript("$http.res.data.module.name");
        scriptEntity.setValName("base64");
        ScriptSourceBean scriptSourceBean = parseParams(source, scriptEntity);
        System.out.println(scriptSourceBean);
    }
}
