package cn.easyutil.easyapi.logic.el;

import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * el的执行器
 */
public class ElExpression {

    //存放环境变量
    private StandardEvaluationContext context = new StandardEvaluationContext();

    private SpelExpressionParser parser = new SpelExpressionParser();

    private List<SpelParser> customParsers = new ArrayList<>();

    /**
     * 使用解析器来构建执行器，如果没有解析器则直接使用spel解析器
     * @param customParsers
     * @return
     */
    public static ElExpression with(SpelParser...customParsers){
        ElExpression expression = new ElExpression();
        expression.customParsers.addAll(Arrays.asList(customParsers));
        return expression;
    }

    public Object getVal(String el){
        if(StringUtil.isEmpty(el)){
            return "";
        }
        String parse = el;
        for (SpelParser customParser : customParsers) {
            parse = customParser.parse(parse);
        }
        try {
            return parser.parseExpression(parse).getValue(context);
        }catch (Exception e){
            return parse;
        }
    }

    public void addParser(SpelParser parser){
        if(parser != null){
            this.customParsers.add(parser);
        }
    }

    public void setVariable(String key,Object val){
        context.setVariable(key, val);
    }

    public void setVariables(Map<String,Object> vals){
        context.setVariables(vals);
    }
}
