package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.*;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.logic.condition.MockProcess;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.core.DefaultParameterNameDiscoverer;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

public class MethodParamsCreator {

    private Class clazz;

    private Method method;

    private ApiExtra extra;

    private ReadRequestParamApiFilter reqFilter = new DefaultReadRequestParamApi();

    private ReadResponseParamApiFilter resFilter = new DefaultReadResponseParamApi();

    private ReadJavaBeanApiFilter javaBeanApiFilter = new DefaultReadJavaBeanApi();

    private ReadMockTemplateFilter mockFilter = new DefaultReadMockTemplate(ElExpression.with(DefaultSpelMethodParser.get()));

    private List<DocParamEntity> requestParameters = new ArrayList<>();

    private List<DocParamEntity> returnParameter = new ArrayList<>();

    private String responseMock = "";
    private String requestMock = "";

    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz,Method method){
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz){
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateFilter mockFilter){
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestParamApiFilter reqFilter){
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseParamApiFilter resFilter){
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadJavaBeanApiFilter beanFilter){
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator){
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method){
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra){
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create(){
        try {
            createParameters();
            createReturnType();
            MockProcess2 mocker = MockProcess2.with(mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(requestParameters);
            Object res = mocker.mockByApiParams(returnParameter);
            requestMock = ObjectUtil.isBaseObject(req)?req.toString():JsonUtil.beanToJson(req);
            responseMock = ObjectUtil.isBaseObject(res)?res.toString():JsonUtil.beanToJson(res);
            return this;
        }catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("接口参数构建失败:"+clazz.getCanonicalName()+"."+method.getName());
        }
    }

    private void createParameters(){
        extra.setParameter(null);
        List<MethodParam> params = reqFilter.params(this.method, extra);
        if(params == null){
            return ;
        }
        for (MethodParam param : params) {
            Parameter parameter = param.getParameter();
            String paramName = param.getParamName();
            Type paramType = param.getParamType();
            Class<?> ownerClass = GenericTypeUtil.getOwnerClass(paramType);
            extra.setModelClass(ownerClass);
            extra.setParameter(parameter);
            if(reqFilter.ignore(paramType, ownerClass,extra)){
                continue;
            }
            if(paramType==null || ownerClass==null){
                return ;
            }
            String description = reqFilter.description(paramType, paramName,extra);
            if(StringUtil.isEmpty(description)){
                description = extra.getMethodComment().getParameter(paramName).getComment();
            }
            JavaType javaType = JavaType.getJavaTypeByType(paramType);
            //补充基本信息
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(description);
            entity.setMockTemplate(reqFilter.mockTemplate(paramType,extra));
            entity.setName(paramName);
            entity.setClassName(ownerClass.getCanonicalName());
            entity.setRequired(reqFilter.required(paramType,extra)?1:0);
            entity.setShow(reqFilter.show(paramType,extra)?1:0);
            entity.setJavaType(javaType.getType());
            this.requestParameters.addAll(createParam(paramType, entity));
        }
    }

    private void createReturnType(){
        extra.setReturnType(null);
        List<MethodParam> types = resFilter.returnTypes(method, extra);
        if(types == null){
            return ;
        }
        extra.setMethod(method);
        for (MethodParam param : types) {
            Type type = param.getParamType();
            if(type == Void.TYPE){
                return ;
            }
            extra.setReturnType(type);
            Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
            GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
            extra.setModelClass(ownerClass);
            //获取自定义类型
            if(type==null || ownerClass==null){
                return ;
            }
            //判断是否需要忽略
            if(resFilter.ignore(type, ownerClass, bind,extra)){
                return ;
            }
            JavaType javaType = JavaType.getJavaTypeByType(type);
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(resFilter.description(type,extra));
            entity.setMockTemplate(resFilter.mockTemplate(type,extra));
            entity.setRequired(resFilter.required(type,ownerClass,bind,extra)?1:0);
            entity.setShow(resFilter.show(type,ownerClass,bind,extra)?1:0);
            entity.setName(JavaBeanCreator.nullKey);
            if(!StringUtil.isEmpty(param.getParamName())){
                entity.setName(param.getParamName());
            }
            entity.setClassName(ownerClass.getCanonicalName());
            entity.setJavaType(javaType.getType());
            List<DocParamEntity> paramsEntity = createParam(type, entity);
            if(entity.getName().equals(JavaBeanCreator.nullKey)){
                returnParameter.addAll(paramsEntity);
            }else{
                if(paramsEntity.size()!=1 || !paramsEntity.get(0).getUnique().equals(entity.getUnique())){
                    entity.setChildren(paramsEntity);
                }
                returnParameter.add(entity);
            }
        }
    }
    /**
     * 构建参数
     * @param type
     * @param entity
     * @return
     */
    private List<DocParamEntity> createParam(Type type,DocParamEntity entity){
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        JavaType javaType = JavaType.getType(entity.getJavaType());
        //已经创建好的bean对象，避免无限递归循环
        Map<String, List<DocParamEntity>> exists = new HashMap<>();
        if(javaType == JavaType.Object){
            return javaBeanCreator.readBean(type,bind,exists);
        }
        entity.setClassName(GenericTypeUtil.getOwnerClass(type).getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType){
            case Array:{
                entity.setChildren(javaBeanCreator.readArray(type,bind));
                break;
            }
            case ArrayObject:{
                entity.setChildren(javaBeanCreator.readArrayObject(type,bind,exists));
                break;
            }
        }
        Object mockValue = mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = extra.getControllerClass().getCanonicalName()+extra.getMethod().toGenericString()+entity.getClassName()+entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        RenewType renewType = javaBeanApiFilter.renewType(extra.getModelClass(), bind, extra);
        entity.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
        return Collections.singletonList(entity);
    }


    public List<DocParamEntity> getRequestParameters() {
        return requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }
}
