package cn.easyutil.easyapi.logic.condition;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

public class MockProcess2 {
    private ReadMockTemplateFilter filter;
    private int mockArraySize = 12;

    public static MockProcess2 with(ReadMockTemplateFilter filter){
        MockProcess2 mocker = new MockProcess2();
        mocker.filter = filter;
        return mocker;
    }

    public Object mockByApiParams(String param){
        return mockByApiParams(JSONObject.parseArray(param, DocParamEntity.class));
    }

    public Object mockByApiParams(List<DocParamEntity> params){
        Map<String,Object> result = new HashMap<>();
        mockByApiParams(params,result);
        if(result.size()==1 && result.containsKey(ProjectContext.nullKey)){
            return result.get(ProjectContext.nullKey);
        }
        return result;
    }

    public void mockByApiParams(List<DocParamEntity> params,Map<String,Object> result){
        if(params==null || params.size()==0){
            return ;
        }
        for (DocParamEntity param : params) {
            JavaType type = JavaType.getType(param.getJavaType());
            if(JavaType.isBaseType(type)){
                Object val = mockValue(param);
                param.setMockValue(val.toString());
                result.put(param.getName(),val);
                continue;
            }
            List<DocParamEntity> children = param.getChildren();
            Map<String,Object> childrenMap = new HashMap<>();
            switch (type){
                case Object:{
                    mockByApiParams(children,childrenMap);
                    result.put(param.getName(),childrenMap);
                    break;
                }
                case ArrayObject:{
                    List<Map<String,Object>> listChildren = new ArrayList<>();
                    for (int i = 0; i < mockArraySize; i++) {
                        childrenMap = new HashMap<>();
                        mockByApiParams(children,childrenMap);
                        listChildren.add(childrenMap);
                    }
                    result.put(param.getName(),listChildren);
                    break;
                }
                case Array:{
                    List<Object> listChildren = new ArrayList<>();
                    for (int i = 0; i < mockArraySize; i++) {
                        childrenMap = new HashMap<>();
                        mockByApiParams(children,childrenMap);
                        listChildren.add(childrenMap.get(ProjectContext.nullKey));
                    }
                    result.put(param.getName(), listChildren);
                    break;
                }
            }
        }
    }


    private Object mockValue(DocParamEntity entity){
        if(entity==null || entity.getJavaType()==null){
            return "";
        }
        String template = entity.getMockTemplate();
        JavaType javaType = JavaType.getType(entity.getJavaType());
        return filter.mock(template, javaType);
    }

    public void setMockArraySize(int mockArraySize) {
        this.mockArraySize = mockArraySize;
    }
}
