package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.service.ModuleService;
import cn.easyutil.easyapi.util.AssertUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@ConditionalOnMissingBean(name = "easyapiModuleController")
@RequestMapping("/easyapi/doc/module")
public class ModuleController {

    @Resource(name = "easyapiModuleService")
    private ModuleService moduleService;

    @ApidocComment("获取模块列表")
    @PostMapping("/getModules")
    @AccessAuth(code = 1000)
    public List<DBModuleEntity> getModules(){
        Long projectId = CurrentSession.getCurrentProjectId();
        List<Integer> modules = CurrentSession.getCurrentUser().getProjectIds().get(projectId);
        List<DBModuleEntity> list = moduleService.list(EasyapiBindSQLExecuter.build(new DBModuleEntity()).in(DBModuleEntity::getId, modules));
        return list;
    }

    @ApidocComment("修改模块信息")
    @PostMapping("/updateModules")
    @AccessAuth(code = 1000)
    public void updateModules(@RequestBody DBModuleEntity entity){
        AssertUtil.isNull(entity.getId(), "项目id不能为空");
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = moduleService.get(query);
            AssertUtil.isTrue(query!=null, "只能有一个默认模块");
        }
        moduleService.update(entity);
    }

    @ApidocComment("新增模块信息")
    @PostMapping("/addModules")
    @AccessAuth(code = 1000)
    public void addModules(@RequestBody DBModuleEntity entity){
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = moduleService.get(query);
            AssertUtil.isTrue(query!=null, "只能有一个默认模块");
        }
        moduleService.insert(entity);
    }

    @ApidocComment("删除模块信息")
    @PostMapping("/delModules")
    @AccessAuth(code = 1000)
    public void delModules(@RequestBody IdDto dto){
        moduleService.deleteById(dto.getId());
    }
}
