package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadControllerApiFilter;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultReadControllerApi extends ReadControllerApiFilter {

    @Override
    public Set<Class> readControllers(ApplicationContext springContext) {
        Map<String, Object> beansWithAnnotation = springContext.getBeansWithAnnotation(Controller.class);
        Set<Class> set = new HashSet<>();
        Iterator<Map.Entry<String, Object>> iterator = beansWithAnnotation.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, Object> next = iterator.next();
            Object value = next.getValue();
            Class<?> aClass = value.getClass();
            if(aClass.getCanonicalName().contains("cn.easyutil.easyapi")){
                continue;
            }
            if(aClass.getCanonicalName().contains("$$")){
                set.add(aClass.getSuperclass());
                continue;
            }
            set.add(aClass);
        }
        return set;
    }

    @Override
    public boolean ignore(Class controller, ApiExtra extra) {
        if(controller.getCanonicalName().startsWith("org.springframework")){
            return true;
        }
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(controller, ApidocComment.class);
        if(classAnnotation!=null && classAnnotation.size()>0){
            if(classAnnotation.get(controller.getName()) != null){
                if(classAnnotation.get(controller.getName()).ignore()){
                    //被忽略的控制器
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean show(Class controller, ApiExtra extra) {
        return true;
    }

    @Override
    public String showName(Class controller, ApiExtra extra) {
        //最先判断本项目提供的注解
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(controller, ApidocComment.class);
        if (classAnnotation != null && !classAnnotation.isEmpty()) {
            return classAnnotation.entrySet().iterator().next().getValue().value();
        }
        // 优先读取swagger注解
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.Api", controller.getAnnotations());
        if(annotation != null){
            Object tags = AnnotationUtil.getAnnotationValue(annotation, "tags");
            if(tags != null){
                String[] tgs = (String[]) tags;
                if(tgs.length>0 && !StringUtil.isEmpty(tgs[0])){
                    return tgs[0];
                }
            }
            return (String) AnnotationUtil.getAnnotationValue(annotation, "value");
        }
        return extra.getControllerComment().getComment();
    }

    @Override
    public String requestPath(Class controller, ApiExtra extra) {
        String mapping = SpringUtil.getRequestPath(controller);
        if(StringUtil.isEmpty(mapping)){
            return "";
        }
        // 获取请求路径
        String baseUrl = "";
        baseUrl += mapping;
        baseUrl = parseUrl(baseUrl);
        return baseUrl;
    }

    @Override
    public String description(Class controller, ApiExtra extra) {
        return null;
    }

    @Override
    public String author(Class controller, ApiExtra extra) {
        return null;
    }


    /**
     * 完善请求路径
     *
     * @param requestUrl
     * @return
     */
    private static String parseUrl(String requestUrl) {
        if(StringUtil.isEmpty(requestUrl)){
            return null;
        }
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}
