package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.unit.OperEnum;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;

import javax.script.*;
import java.sql.Blob;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 简单测试
 */
@Tne("EASYAPI_SIMPLE_UNIT")
public class DBSimpleUnitEntity extends BaseDbEntity {

    @Tfd(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd(value = "INTERFACE_ID",ddl = "`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd(value = "TYPE",ddl = "`TYPE` int(1) DEFAULT 0 COMMENT '类型：0-最近执行  1-历史记录'")
    @ApidocComment("类型：0-最近执行  1-历史记录")
    private Integer type;

    @Tfd(value = "USE_STYLE_TYPE",ddl = "`USE_STYLE_TYPE` int(1) DEFAULT 0 COMMENT '页面初始展示类型： 0-table 1-json'")
    @ApidocComment("类型：0-最近执行  1-历史记录")
    private Integer useStyleType;

    @Tfd(value = "NAME",ddl = "`NAME` varchar(100) DEFAULT NULL COMMENT '测试名称'")
    @ApidocComment("测试名称")
    private String name;

    @Tfd(value = "REQUEST_URL",type = Blob.class,ddl = "`REQUEST_URL` BLOB DEFAULT NULL COMMENT '请求地址'")
    @ApidocComment("测试名称")
    private String requestUrl;

    @Tfd(value = "JSON_PARAMETERS",type = Blob.class,ddl = "`JSON_PARAMETERS` BLOB DEFAULT NULL COMMENT '请求参数'")
    @ApidocComment("请求参数")
    private String jsonParameters;

    @Tfd(value = "JSON_TABLES",type = Blob.class,ddl = "`JSON_TABLES` BLOB DEFAULT NULL COMMENT 'TABLE请求参数'")
    @ApidocComment("table请求参数")
    private String jsonTables;

    @Tfd(value = "JSON_PACKAGES",type = Blob.class,ddl = "`JSON_PACKAGES` BLOB DEFAULT NULL COMMENT '请求参数包装'")
    @ApidocComment("请求参数包装")
    private String jsonPackages;

    @Tfd(value = "JSON_HEADERS",type = Blob.class,ddl = "`JSON_HEADERS` BLOB DEFAULT NULL COMMENT '请求头'")
    @ApidocComment("请求头")
    private String jsonHeaders;

    @Tfd(value = "JSON_RESPONSE",type = Blob.class,ddl = "`JSON_RESPONSE` BLOB DEFAULT NULL COMMENT '接口响应结果'")
    @ApidocComment("接口响应结果")
    private String jsonResponse;

    @Tfd(value = "JSON_RES_HEADERS",type = Blob.class,ddl = "`JSON_RES_HEADERS` BLOB DEFAULT NULL COMMENT '接口响应header'")
    @ApidocComment("接口响应header")
    private String jsonResHeaders;

    @Tfd(value = "ANSWER_TIME",ddl = "`ANSWER_TIME` bigint(20) DEFAULT 0 COMMENT '接口响应时间'")
    @ApidocComment("接口响应时间")
    private Long answerTime;

    @Tfd(value = "JSON_PRE_SCRIPTS",type = Blob.class,ddl = "`JSON_PRE_SCRIPTS` BLOB DEFAULT NULL COMMENT '前置处理脚本'")
    @ApidocComment("后置处理")
    private String jsonPreScripts;

    @Tfd(value = "JSON_POST_SCRIPTS",type = Blob.class,ddl = "`JSON_POST_SCRIPTS` BLOB DEFAULT NULL COMMENT '后置处理脚本'")
    @ApidocComment("后置处理")
    private String jsonPostScripts;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getJsonParameters() {
        return jsonParameters;
    }

    public void setJsonParameters(String jsonParameters) {
        this.jsonParameters = jsonParameters;
    }

    public String getJsonHeaders() {
        return jsonHeaders;
    }

    public void setJsonHeaders(String jsonHeaders) {
        this.jsonHeaders = jsonHeaders;
    }

    public String getJsonResponse() {
        return jsonResponse;
    }

    public void setJsonResponse(String jsonResponse) {
        this.jsonResponse = jsonResponse;
    }

    public String getJsonPackages() {
        return jsonPackages;
    }

    public void setJsonPackages(String jsonPackages) {
        this.jsonPackages = jsonPackages;
    }

    public String getJsonTables() {
        return jsonTables;
    }

    public void setJsonTables(String jsonTables) {
        this.jsonTables = jsonTables;
    }

    public String getJsonPreScripts() {
        return jsonPreScripts;
    }

    public void setJsonPreScripts(String jsonPreScripts) {
        this.jsonPreScripts = jsonPreScripts;
    }

    public String getJsonPostScripts() {
        return jsonPostScripts;
    }

    public void setJsonPostScripts(String jsonPostScripts) {
        this.jsonPostScripts = jsonPostScripts;
    }

    public String getJsonResHeaders() {
        return jsonResHeaders;
    }

    public void setJsonResHeaders(String jsonResHeaders) {
        this.jsonResHeaders = jsonResHeaders;
    }

    public Long getAnswerTime() {
        return answerTime;
    }

    public void setAnswerTime(Long answerTime) {
        this.answerTime = answerTime;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getUseStyleType() {
        return useStyleType;
    }

    public void setUseStyleType(Integer useStyleType) {
        this.useStyleType = useStyleType;
    }

    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }
}
