package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.unit.OperEnum;

/**
 * 复杂测试
 */
@Tne("EASYAPI_COMPLEX_TEST")
public class DBComplexTestEntity extends BaseDbEntity {

    @Tfd(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd(value = "INTERFACE_ID",ddl = "`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd(value = "GROUP_IDS",ddl = "`GROUP_IDS` varchar(255) DEFAULT NULL COMMENT '分组id集合，多条逗号分隔'")
    @ApidocComment("分组id集合，多条逗号分隔")
    private String groupIds;

    @Tfd(value = "SUCCESS_KEY",ddl = "`SUCCESS_KEY` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key(取结果集字段,嵌套使用.获取属性)'")
    @ApidocComment("接口成功标志的key(取结果集字段,嵌套使用.获取属性)")
    private String successKey;

    /**
     * @see OperEnum
     */
    @Tfd(value = "SUCCESS_OPER",ddl = "`SUCCESS_OPER` varchar(20) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符'")
    @ApidocComment("接口成功标志的key对应的运算符")
    private String successOper;

    @Tfd(value = "SUCCESS_VAL",ddl = "`SUCCESS_VAL` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符计算后的结果'")
    @ApidocComment("接口成功标志的key对应的运算符计算后的结果")
    private String successVal;

    @Tfd(value = "TIME_CONSUMING",ddl = "`TIME_CONSUMING` bigint(20) DEFAULT NULL COMMENT '耗时'")
    @ApidocComment("耗时")
    private Long timeConsuming;

    @Tfd(value = "SUCCESS_COUNT",ddl = "`SUCCESS_COUNT` int(10) DEFAULT 0 COMMENT '成功数'")
    @ApidocComment("成功数")
    private Integer successCount;

    @Tfd(value = "FAIL_COUNT",ddl = "`FAIL_COUNT` int(10) DEFAULT 0 COMMENT '失败数'")
    @ApidocComment("失败数")
    private Integer failCount;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getSuccessKey() {
        return successKey;
    }

    public void setSuccessKey(String successKey) {
        this.successKey = successKey;
    }

    public String getSuccessOper() {
        return successOper;
    }

    public void setSuccessOper(String successOper) {
        this.successOper = successOper;
    }

    public String getSuccessVal() {
        return successVal;
    }

    public void setSuccessVal(String successVal) {
        this.successVal = successVal;
    }

    public Long getTimeConsuming() {
        return timeConsuming;
    }

    public void setTimeConsuming(Long timeConsuming) {
        this.timeConsuming = timeConsuming;
    }

    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public String getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }
}
