package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

import java.sql.Blob;

/**
 * 模块全局脚本
 */
@Tne("EASYAPI_MODULE_SCRIPT")
public class DBModuleScriptEntity extends BaseDbEntity {

    @Tfd(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
    @ApidocComment("模块id")
    private Long moduleId;

    @Tfd(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd(value = "TYPE",ddl = "`TYPE` int(1) DEFAULT 0 COMMENT '类型  0-私有 1-共有'")
    @ApidocComment("类型  0-私有 1-共有")
    private Integer type;

    @Tfd(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(50) DEFAULT NULL COMMENT '脚本说明'")
    @ApidocComment("脚本说明")
    private String description;

    @Tfd(value = "VAL_NAME",ddl = "`VAL_NAME` varchar(100) DEFAULT NULL COMMENT '要处理的字段名称'")
    @ApidocComment("要处理的字段名称")
    private String valName;

    @Tfd(value = "VAL_TYPE",ddl = "`VAL_TYPE` varchar(20) DEFAULT NULL COMMENT '脚本要操作的数据  header,env,req,res'")
    @ApidocComment("脚本要操作的数据  header,env,req,res")
    private String valType;

    @Tfd(value = "SCRIPT",ddl = "`SCRIPT` varchar(255) DEFAULT NULL COMMENT '具体脚本'")
    @ApidocComment("具体脚本")
    private String script;

    @Tfd(value = "PARSE_KEY",ddl = "`PARSE_KEY` varchar(255) DEFAULT NULL COMMENT '处理参数时的方法密钥'")
    @ApidocComment("处理参数时的方法密钥")
    private String parseKey;

    @Tfd(value = "PARSE_TYPE",ddl = "`PARSE_TYPE` varchar(20) DEFAULT NULL COMMENT '处理方式  encode/decode'")
    @ApidocComment("处理方式  encode/decode")
    private String parseType;

    @Tfd(value = "CONDITION",ddl = "`CONDITION` varchar(255) DEFAULT NULL COMMENT '断言'")
    @ApidocComment("断言语法")
    private String condition;

    @Tfd(value = "LOCATION",ddl = "`LOCATION` int(1) DEFAULT 0 COMMENT '0-前置 1-后置'")
    @ApidocComment("0-前置 1-后置")
    private Integer location;

    @Tfd(value = "JS",type = Blob.class,ddl = "`JS` BLOB DEFAULT NULL COMMENT '转换后的纯js脚本'")
    @ApidocComment("转换后的纯js脚本")
    private String js;

    @Tfd(value = "SORT",ddl = "`SORT` int(2) DEFAULT 1 COMMENT '排序字段'")
    @ApidocComment("排序")
    private Integer sort;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValName() {
        return valName;
    }

    public void setValName(String valName) {
        this.valName = valName;
    }

    public String getValType() {
        return valType;
    }

    public void setValType(String valType) {
        this.valType = valType;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getParseKey() {
        return parseKey;
    }

    public void setParseKey(String parseKey) {
        this.parseKey = parseKey;
    }

    public String getParseType() {
        return parseType;
    }

    public void setParseType(String parseType) {
        this.parseType = parseType;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Integer getLocation() {
        return location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    public String getJs() {
        return js;
    }

    public void setJs(String js) {
        this.js = js;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
