package cn.easyutil.easyapi.content;

/**
 * sql脚本DDL语句
 */
public class TableDDL {

    /**
     * 全部数据库表DDL
     */
    public static String[] all = new String[] {
            project(),
            roleAuth(),
            role(),
            roleProject(),
            user(),
            simpleUnit(),
            complexTest(),
            complexTestGroup(),
            complexTestInfo(),
            interfaceParam(),
            controllers(),
            module(),
            host(),
            interfaces(),
            outPackage(),
            env(),
            header(),
            script(),
            param(),
            userTemporaryAuth()
    };

    /**
     * 删除全表
     */
    public static String[] dropAll = new String[] {
            "DROP TABLE IF EXISTS EASYAPI_PROJECT;",
            "DROP TABLE IF EXISTS EASYAPI_ROLE_AUTH;",
            "DROP TABLE IF EXISTS EASYAPI_ROLE_PROJECTS;",
            "DROP TABLE IF EXISTS EASYAPI_ROLE;" ,
            "DROP TABLE IF EXISTS EASYAPI_USER;" ,
            "DROP TABLE IF EXISTS EASYAPI_COMPLEX_TEST;" ,
            "DROP TABLE IF EXISTS EASYAPI_COMPLEX_TEST_GROUP;" ,
            "DROP TABLE IF EXISTS EASYAPI_COMPLEX_TEST_INFO;",
            "DROP TABLE IF EXISTS EASYAPI_INTERFACE_PARAM;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_CONTROLLER;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_HOST;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_INTERFACE;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_OUT_PACKAGE;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_ENV;",
            "DROP TABLE IF EXISTS EASYAPI_USER_TEMPORARY_AUTH;",
            "DROP TABLE IF EXISTS EASYAPI_MODULE_HEADER;",
            "DROP TABLE IF EXISTS EASYAPI_SIMPLE_UNIT;",
            "DROP TABLE IF EXISTS EASYAPI_PARAM;"
    };

    /**
     * 删除接口文档相关的表
     */
    public static String[] dropDoc = new String[] {
            "TRUNCATE table EASYAPI_COMPLEX_TEST;" ,
            "TRUNCATE table EASYAPI_COMPLEX_TEST_GROUP;" ,
            "TRUNCATE table EASYAPI_COMPLEX_TEST_INFO;",
            "TRUNCATE table EASYAPI_INTERFACE_PARAM;",
            "TRUNCATE table EASYAPI_MODULE_CONTROLLER;",
            "TRUNCATE table EASYAPI_MODULE_INTERFACE;",
//            "TRUNCATE table EASYAPI_MODULE_OUT_PACKAGE;",
            "TRUNCATE table EASYAPI_PARAM;"
    };

    public static String project(){
        return "CREATE TABLE if not exists `EASYAPI_PROJECT` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `TITLE` varchar(100) DEFAULT NULL COMMENT '项目标题',\n" +
                "  `NAME` varchar(100) DEFAULT NULL COMMENT '项目名称',\n" +
                "  `DESCRIPTION` BLOB DEFAULT NULL COMMENT '项目介绍',\n" +
                "  `INDEX_BANNER` BLOB DEFAULT NULL COMMENT '项目首页广告内容',\n" +
                "  `DISABLE` int(1) DEFAULT 0 COMMENT '项目状态:0-正常  1-关闭',\n" +
                "  `DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '是否默认项目 0-不是  1-是',\n" +
                "  `ENABLE_REQ_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启请求参数外包装 0-否  1-是',\n" +
                "  `ENABLE_RES_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启返回参数外包装 0-否  1-是',\n" +
                "  `IMGS` BLOB DEFAULT NULL COMMENT '项目图片',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String roleAuth(){
        return "CREATE TABLE if not exists `EASYAPI_ROLE_AUTH` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色id',\n" +
                "  `AUTH_CODE` int(10) DEFAULT NULL COMMENT '可访问的接口编码',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String userTemporaryAuth(){
        return "CREATE TABLE if not exists `EASYAPI_USER_TEMPORARY_AUTH` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `AUTH_CODE` int(10) DEFAULT NULL COMMENT '可访问的接口编码',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String role(){
        return "CREATE TABLE if not exists `EASYAPI_ROLE` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +
                "  `DEFAULT_ROLE` int(1) DEFAULT 0 COMMENT '是否默认角色：0-否 1-是',\n" +

                "  `ROLE_NAME` varchar(50) DEFAULT NULL COMMENT '角色名称',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '角色说明',\n" +
                "  `SUPER_ADMIN_STATUS` int(1) DEFAULT 0 COMMENT '是否超级管理员:0-不是  1-是',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String roleProject(){
        return "CREATE TABLE if not exists `EASYAPI_ROLE_PROJECTS` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色id',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String user(){
        return "CREATE TABLE if not exists `EASYAPI_USER` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `ACCOUNT` varchar(20) DEFAULT NULL COMMENT '账号名',\n" +
                "  `PASSWORD` varchar(50) DEFAULT NULL COMMENT '密码',\n" +
                "  `MOBILE` varchar(20) DEFAULT NULL COMMENT '手机号码',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '介绍',\n" +
                "  `HEADER_IMG` varchar(255) DEFAULT NULL COMMENT '头像',\n" +
                "  `NICK_NAME` varchar(50) DEFAULT NULL COMMENT '昵称',\n" +
                "  `LAST_OPEND_INTERFACE_IDS` varchar(255) DEFAULT NULL COMMENT '上次打开的接口id集合',\n" +
                "  `LAST_LOGIN_TIME` bigint(20) DEFAULT NULL COMMENT '上次登陆时间',\n" +
                "  `DISABLE` int(1) DEFAULT 0 COMMENT '0-未禁用 1-已禁用',\n" +
                "  `SUPER_ADMIN_STATUS` int(1) DEFAULT 0 COMMENT '是否超级管理员:0-不是  1-是',\n" +
                "  `ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色id',\n" +
                "  `HIDDEN` int(1) DEFAULT 0 COMMENT '是否隐藏:0-不隐藏  1-隐藏',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String simpleUnit(){
        return "CREATE TABLE if not exists `EASYAPI_SIMPLE_UNIT` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id',\n" +
                "  `JSON_PARAMETERS` BLOB DEFAULT NULL COMMENT '请求参数',\n" +
                "  `JSON_TABLES` BLOB DEFAULT NULL COMMENT 'TABLE请求参数',\n" +
                "  `JSON_PACKAGES` BLOB DEFAULT NULL COMMENT '请求参数包装',\n" +
                "  `JSON_HEADERS` BLOB DEFAULT NULL COMMENT '请求头',\n" +
                "  `JSON_RESPONSE` BLOB DEFAULT NULL COMMENT '接口响应结果',\n" +
                "  `JSON_SCRIPTS` BLOB DEFAULT NULL COMMENT '后置处理脚本',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String complexTest(){
        return "CREATE TABLE if not exists `EASYAPI_COMPLEX_TEST` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id',\n" +
                "  `GROUP_IDS` varchar(255) DEFAULT NULL COMMENT '分组id集合，多条逗号分隔',\n" +
                "  `SUCCESS_KEY` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key(取结果集字段,嵌套使用.获取属性)',\n" +
                "  `SUCCESS_OPER` varchar(20) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符',\n" +
                "  `SUCCESS_VAL` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符计算后的结果',\n" +
                "  `TIME_CONSUMING` bigint(20) DEFAULT NULL COMMENT '耗时',\n" +
                "  `SUCCESS_COUNT` int(10) DEFAULT 0 COMMENT '成功数',\n" +
                "  `FAIL_COUNT` int(10) DEFAULT 0 COMMENT '失败数',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String complexTestGroup(){
        return "CREATE TABLE if not exists `EASYAPI_COMPLEX_TEST_GROUP` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id',\n" +
                "  `NAME` varchar(255) DEFAULT NULL COMMENT '配置名称',\n" +
                "  `THREAD_COUNT` int(10) DEFAULT NULL COMMENT '线程数',\n" +
                "  `REQUEST_HEADERS` varchar(255) DEFAULT NULL COMMENT '请求头',\n" +
                "  `REQUEST_PARAM` varchar(255) DEFAULT NULL COMMENT '请求参数',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String complexTestInfo(){
        return "CREATE TABLE if not exists `EASYAPI_COMPLEX_TEST_INFO` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id',\n" +
                "  `TEST_ID` bigint(20) DEFAULT NULL COMMENT '单元测试id',\n" +
                "  `HTTP_STATUS` int(5) DEFAULT NULL COMMENT 'http状态码',\n" +
                "  `SUCCESS_KEY` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key(取结果集字段,嵌套使用.获取属性)',\n" +
                "  `SUCCESS_OPER` varchar(20) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符',\n" +
                "  `SUCCESS_VAL` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符计算后的结果',\n" +
                "  `REAL_VAL` varchar(255) DEFAULT NULL COMMENT '真实返回的值',\n" +
                "  `REQUEST_HEADERS` varchar(255) DEFAULT NULL COMMENT '请求头',\n" +
                "  `REQUEST_PARAM` varchar(255) DEFAULT NULL COMMENT '请求参数',\n" +
                "  `RESPONSE_HEADERS` varchar(255) DEFAULT NULL COMMENT '响应头',\n" +
                "  `RESPONSE_PARAM` BLOB DEFAULT NULL COMMENT '响应结果',\n" +
                "  `SUCCESS_STATUS` int(1) DEFAULT 0 COMMENT '0-失败 1-成功',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String interfaceParam(){
        return "CREATE TABLE if not exists `EASYAPI_INTERFACE_PARAM` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id',\n" +
                "  `REQUEST_DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '请求参数说明',\n" +
                "  `RESPONSE_DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '响应参数说明',\n" +
                "  `REQUEST_PARAM_JSON` BLOB DEFAULT NULL COMMENT '请求参数详情json',\n" +
                "  `RESPONSE_PARAM_JSON` BLOB DEFAULT NULL COMMENT '响应参数详情json',\n" +
                "  `REQUEST_MOCK` BLOB DEFAULT NULL COMMENT '请求参数mock',\n" +
                "  `RESPONSE_MOCK` BLOB DEFAULT NULL COMMENT '响应结果mock',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String controllers(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_CONTROLLER` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '所属模块id',\n" +
                "  `CLASS_NAME` varchar(100) DEFAULT 0 COMMENT '控制器全类名',\n" +
                "  `SHOW_NAME` varchar(100) DEFAULT NULL COMMENT '控制器名称',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '控制器说明',\n" +
                "  `AUTHOR` varchar(20) DEFAULT NULL COMMENT '控制器作者',\n" +
                "  `PINYIN` varchar(255) DEFAULT NULL COMMENT '控制器名称拼音',\n" +
                "  `API_PATH` varchar(50) DEFAULT NULL COMMENT '统一请求的父路径',\n" +
                "  `SORT` int(5) DEFAULT 0 COMMENT '排序值,值越小，排名越靠前',\n" +
                "  `SOURCE` BLOB DEFAULT NULL COMMENT '源代码',\n" +
                "  `SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '搜索字段',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String module(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `NAME` varchar(100) DEFAULT NULL COMMENT '模块名称',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT 0 COMMENT '模块说明',\n" +
                "  `DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '默认状态：0-默认模块  1-创建模块',\n" +
                "  `OUT_PACKGE_STATUS` int(1) DEFAULT 0 COMMENT '本模块是否添加返回外包装 0-不添加  1-添加',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String host(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_HOST` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +
                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `NAME` varchar(50) DEFAULT NULL COMMENT '环境名称',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '环境描述',\n" +
                "  `HOST` varchar(255) DEFAULT NULL COMMENT '环境ip或域名',\n" +
                "  `DISABLE` int(1) DEFAULT 0 COMMENT '环境状态:0-正常  1-关闭',\n" +
                "  `CAN_DELETE` int(1) DEFAULT 1 COMMENT '是否可删除  0-不可删除  1-可以删除',\n" +
                "  `DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '是否默认环境 0-不是  1-是',\n" +
                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String interfaces(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_INTERFACE` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `CONTROLLER_ID` bigint(20) DEFAULT NULL COMMENT '控制器id',\n" +
                "  `CONTROLLER_CLASS` varchar(100) DEFAULT NULL COMMENT '控制器名称',\n" +
                "  `METHOD_NAME` varchar(255) DEFAULT NULL COMMENT '接口方法名',\n" +
                "  `UNIQUE` varchar(50) DEFAULT NULL COMMENT '接口唯一标识',\n" +
                "  `SHOW_NAME` varchar(100) DEFAULT NULL COMMENT '接口标题',\n" +
                "  `PINYIN` varchar(100) DEFAULT NULL COMMENT '接口标题拼音',\n" +
                "  `DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '接口说明',\n" +
                "  `REQUEST_URL` varchar(100) DEFAULT NULL COMMENT '请求地址',\n" +
                "  `REQUEST_METHOD` int(1) DEFAULT 0 COMMENT '请求方式 0-全部  1-get  2-post',\n" +
                "  `REQUEST_TYPE` int(1) DEFAULT 0 COMMENT '请求体类型 0-form  1-json体  2-文件上传 3-XML 4-RAW',\n" +
                "  `SORT` int(5) DEFAULT 0 COMMENT '排序值',\n" +
                "  `UPGRADE_STATUS` int(1) DEFAULT 0 COMMENT '接口版本  0-最新版本 1-待更新',\n" +
                "  `SOURCE` BLOB DEFAULT NULL COMMENT '源代码',\n" +
                "  `SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '搜索字段',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String outPackage(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_OUT_PACKAGE` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `KEY` varchar(100) DEFAULT NULL COMMENT '包装的key',\n" +
                "  `TYPE` int(2) DEFAULT 0 COMMENT '类型  0-请求参数包装  1-响应参数包装',\n" +
                "  `VAL` varchar(255) DEFAULT NULL COMMENT '包装的val,如果是默认，则会替换真实数据',\n" +
                "  `DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '默认状态：0-缺省默认值  1-数据包装',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String env(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_ENV` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `NAME` varchar(50) DEFAULT NULL COMMENT '环境变量名称',\n" +
                "  `KEY` varchar(100) DEFAULT NULL COMMENT '环境变量key',\n" +
                "  `VAL` varchar(255) DEFAULT NULL COMMENT '包装的val,如果是默认，则会替换真实数据',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String header(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_HEADER` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `NAME` varchar(50) DEFAULT NULL COMMENT '名称',\n" +
                "  `KEY` varchar(100) DEFAULT NULL COMMENT 'key',\n" +
                "  `VAL` varchar(255) DEFAULT NULL COMMENT 'val',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

    public static String script(){
        return "CREATE TABLE if not exists `EASYAPI_MODULE_SCRIPT` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +

                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id',\n" +
                "  `DESCRIPTION` varchar(50) DEFAULT NULL COMMENT '脚本说明',\n" +
                "  `VAL_NAME` varchar(100) DEFAULT NULL COMMENT '要处理的字段名称',\n" +
                "  `VAL_TYPE` varchar(20) DEFAULT NULL COMMENT '脚本要操作的数据  header,env,req,res',\n" +
                "  `SCRIPT` varchar(255) DEFAULT NULL COMMENT '具体脚本',\n" +
                "  `PARSE_KEY` varchar(255) DEFAULT NULL COMMENT '处理参数时的方法密钥',\n" +
                "  `PARSE_TYPE` varchar(20) DEFAULT NULL COMMENT '处理方式  encode/decode',\n" +
                "  `SORT` int(2) DEFAULT 1 COMMENT '排序字段',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }


    public static String param(){
        return "CREATE TABLE if not exists `EASYAPI_PARAM` (\n" +
                "  `ID` bigint(20) NOT NULL auto_increment,\n" +
                "  `CREATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `UPDATE_TIME` bigint(20) DEFAULT NULL,\n" +
                "  `DELETED` int(1) DEFAULT 0,\n" +
                "  `PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id',\n" +


                "  `MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id',\n" +
                "  `CLASS_NAME` varchar(100) DEFAULT NULL COMMENT '包名+类名',\n" +
                "  `NAME` varchar(50) DEFAULT NULL COMMENT '字段名称',\n" +
                "  `JAVA_TYPE` int(2) DEFAULT 0 COMMENT '参照javaType',\n" +
                "  `MOCK_VALUE` varchar(255) DEFAULT NULL COMMENT '根据template生成的值',\n" +
                "  `MOCK_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '原始未被替换的mockvalue的值',\n" +
                "  `CONDITION_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '参数的校验值，多条逗号分隔',\n" +
                "  `REQUIRED` int(1) DEFAULT 0 COMMENT '是否必填 0-不必填  1-必填',\n" +
                "  `SHOW` int(1) DEFAULT 0 COMMENT '是否显示  0-不显示  1-显示',\n" +
                "  `PARENT_ID` bigint(20) DEFAULT NULL COMMENT '父参数id',\n" +
                "  `PARENT_CLASS` varchar(255) DEFAULT NULL COMMENT '父参数类型',\n" +
                "  `SOURCE` BLOB DEFAULT NULL COMMENT '源代码',\n" +

                "  PRIMARY KEY (`ID`)\n" +
                ") ;";
    }

}
