package cn.easyutil.easyapi.service;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleService extends DBService<DBModuleEntity>{
    @Resource(name = "easyapiInterfaceService")
    private InterfaceService interfaceService;

    @Resource(name = "easyapiControllerService")
    private ControllerService controllerService;

    @Resource(name = "easyapiHostService")
    private HostService hostService;

    @Resource(name = "easyapiOutPackageService")
    private OutPackageService outPackageService;

    @Resource(name = "easyapiParamService")
    private ParamService paramService;

    @Override
    public void deleteById(Long id) {
        clearById(id);
        super.deleteById(id);
    }

    public void clearById(Long id){
        DBModuleEntity module = getById(id);
        if(module == null){
            return ;
        }
        controllerService.delete(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity())
                .eq(DBModuleControllerEntity::getModuleId, module.getId())
        );
        hostService.delete(EasyapiBindSQLExecuter.build(new DBModuleHostEntity())
                .eq(DBModuleHostEntity::getModuleId, module.getId())
        );
        paramService.delete(EasyapiBindSQLExecuter.build(new DBParamEntity())
                .eq(DBParamEntity::getModuleId, module.getId())
        );
        outPackageService.delete(EasyapiBindSQLExecuter.build(new DBModuleOutPackageEntity())
                .eq(DBModuleOutPackageEntity::getModuleId, module.getId())
        );
        List<DBModuleInterfaceEntity> list = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity())
                .eq(DBModuleControllerEntity::getModuleId, module.getId())
                .setReturnParam(DBModuleControllerEntity::getId)
        );
        if(list != null){
            Set<Long> ids = list.stream().map(item -> item.getId()).collect(Collectors.toSet());
            interfaceService.delByIds(ids);
        }
    }
}
