package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadJavaBeanApiFilter;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.*;
import java.util.stream.Collectors;

public class JavaBeanCreator {
    /**
     * 没有key的参数默认key
     */
    public static final String nullKey = "_null";

    private ReadJavaBeanApiFilter filter;

    private ReadMockTemplateFilter mockFilter;
    //项目根目录
    private String projectBasePath;

    private ApiExtra extra;

    public static JavaBeanCreator builder(ReadJavaBeanApiFilter filter, String projectBasePath,ReadMockTemplateFilter mockFilter,ApiExtra extra){
        JavaBeanCreator creator = new JavaBeanCreator(filter,projectBasePath,mockFilter,extra);
        return creator;
    }

    public JavaBeanCreator(ReadJavaBeanApiFilter filter, String projectBasePath,ReadMockTemplateFilter mockFilter,ApiExtra extra){
        this.filter = filter;
        this.projectBasePath = projectBasePath;
        this.mockFilter = mockFilter;
        this.extra = extra;
    }

    private String buildCreatersKey(Class aClass,GenericTypeBind bind){
        String bindKey = "";
        if(bind.keys().size() > 0){
            for (String key : bind.keys()) {
                bindKey += bind.get(key);
            }
        }
        return aClass.getCanonicalName()+bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        Class aClass;
        if(binds == null){
            binds = new GenericTypeBind();
        }
        aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass==Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = buildCreatersKey(aClass, currentBinds);
        if(exists.containsKey(creatersKey)){
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)),DocParamEntity.class);
        }
        exists.put(creatersKey,Collections.emptyList());
        List<DocParamEntity> bean = new ArrayList<>();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType){
            case Object:
                bean = getBean(aClass, binds,exists);
                break;
            case ArrayObject:
                bean = readArrayObject(type, binds,exists);
                break;
            case Array:
                bean = readArray(type, binds);
                break;
        }
        //先放一个占位
        exists.put(creatersKey,bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type,GenericTypeBind binds){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            if(bindType != null){
                arrayType = bindType;
            }else{
                arrayType = genericTypeBind.get(0);
            }
        }
        //基本数据类型
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        RenewType renewType = filter.renewType(extra.getModelClass(), binds, extra.getModelField(), extra);
        childrean.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setUnique(StringUtil.toMD5(extra.getModelField().toGenericString()));
        childrean.setClassName(type.getTypeName());
        childrean.setName(nullKey);
        Object mockValue = mockFilter.mock(childrean.getMockTemplate(), JavaType.getType(childrean.getJavaType()));
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
        childrean.setOrigin(EasyapiOriginUtil.createOrigin(childrean));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            if(Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
                arrayType = binds.get(0);
            }
        }
        if(arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
            arrayType = Map.class;
        }
        //非集合类型
        return readBean(arrayType, binds,exists);
    }

    private List<DocParamEntity> getBean(Class beanClass,GenericTypeBind binds,Map<String,List<DocParamEntity>> exists){
        extra.setModelField(null);
        extra.setFieldComment(null);
        List<DocParamEntity> result = new ArrayList<>();
        //需要读取父类
        Class clazz = beanClass;
        //存放所有子类及父类的字段
        Set<String> fieldNames = new HashSet<>();
        while (clazz!=null && !clazz.equals(Object.class) && clazz!=Class.class) {
            extra.setModelClass(clazz);
            //先读取源码字段注释
            JavaSourceReader classFileReader = JavaSourceReader.builder(CreatorCommonMethod.getClassFile(clazz, this.projectBasePath));
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                extra.setModelField(field);
                extra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                //如果该字段标记忽略，则不解析
                if (filter.ignore(clazz,binds,field,extra)) {
                    continue;
                }
                int size = fieldNames.size();
                fieldNames.add(field.getName());
                if (size == fieldNames.size()) {
                    //父类不覆盖子类，子类最大
                    continue;
                }
                Type type = field.getGenericType();
                //字段类型
                Class ownerClass = GenericTypeUtil.getOwnerClass(type);
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
                //转换类型
                type = filter.type(ownerClass,binds,type,extra);
                ownerClass = GenericTypeUtil.getOwnerClass(type);
                currentBinds = GenericTypeUtil.getGenericTypes(type);
                if(GenericTypeUtil.isGeneric(type) && !GenericTypeUtil.isArray(type)){
                    Type bindType = binds.matchVariable(type.getTypeName());
                    if(bindType != null){
                        type = bindType;
                        ownerClass = GenericTypeUtil.getOwnerClass(type);
                    }
                }
                for (String key : currentBinds.keys()) {
                    Type matchType = binds.matchVariable(currentBinds.get(key).getTypeName());
                    if(matchType != null){
                        currentBinds.bind(key,matchType);
                    }
                }
                if(currentBinds.size() == 0){
                    currentBinds.binds(binds);
                }
                //读取字段说明
                String description = filter.description(ownerClass,binds,field,extra);
                if (StringUtil.isEmpty(description)) {
                    //注释不存在则使用属性名
                    description = field.getName();
                }
                if (!GenericTypeUtil.isArray(type) && (ownerClass==Object.class || ownerClass == Class.class)) {
                    ownerClass = Map.class;
                    type = Map.class;
                }

                JavaType javaType = filter.javaType(ownerClass,binds,type,extra);
                //组装参数
                DocParamEntity entity = new DocParamEntity();
                entity.setName(filter.name(ownerClass,binds,field,extra));
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(filter.mockTemplate(ownerClass, binds, field,extra));
                entity.setShow(filter.show(ownerClass, binds, field,extra)?1:0);
                entity.setRequired(filter.required(ownerClass, binds, field,extra)?1:0);
                entity.setConditionTemplate(filter.conditons(ownerClass, binds, field,extra).stream().collect(Collectors.joining(",")));
                switch (JavaType.getType(entity.getJavaType())) {
                    case Object:
                    case ArrayObject:
                    case Array:
                        entity.setChildren(readBean(type,currentBinds,exists));
                        break;
                    default:
                        Object mockValue = mockFilter.mock(entity.getMockTemplate(), javaType);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
                }
                entity.setUnique(StringUtil.toMD5(field.toGenericString()));
                RenewType renewType = filter.renewType(extra.getModelClass(), binds, extra.getModelField(), extra);
                entity.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
                entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
                result.add(entity);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }
}
