package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;

/**
 * 接口创建
 */
public class InterfaceCreator implements ApiCreator{

    private Method method;

    private DBModuleInterfaceEntity interfaceBean;

    private ReadInterfaceApiFilter filter = new DefaultReadInterfaceApi();

    private ApiExtra extra;

    private InterfaceCreator(){}

    public static InterfaceCreator builder(Method method){
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(ReadInterfaceApiFilter filter){
        if(filter == null){
            return this;
        }
        this.filter = filter;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface(){
        if(interfaceBean != null){
            return interfaceBean;
        }
        try {
            create();
        }catch (Exception e){
            System.out.println("创建接口:"+method.toGenericString()+"失败,原因:"+e.getMessage());
            e.printStackTrace();
        }
        return interfaceBean;
    }

    /**
     * 创建接口说明
     */
    private void create() {
        interfaceBean = new DBModuleInterfaceEntity();
        interfaceBean.setShowName(filter.showName(method,extra));
        //设置接口名称
        if(StringUtil.isEmpty(interfaceBean.getShowName())){
            interfaceBean.setShowName(extra.getMethodComment().getComment());
        }
        if(StringUtil.isEmpty(interfaceBean.getShowName())){
            interfaceBean.setShowName(method.getName());
        }
        interfaceBean.setShow(filter.show(method,extra)?1:0);
        interfaceBean.setShowName(interfaceBean.getShowName().trim());
        interfaceBean.setMethodName(method.getName());
        interfaceBean.setDescription(filter.description(method,extra).trim());
        interfaceBean.setRequestMethod(filter.requestMethod(method,extra));
        RenewType renewType = filter.renewType(method,extra);
        interfaceBean.setRenewType(renewType==null? RenewType.increment.getType():renewType.getType());
        //外面添加
        interfaceBean.setBodyType(filter.bodyType(method,extra).getType());
        interfaceBean.setPinyin(StringUtil.toPinYin(interfaceBean.getShowName()).trim());
        interfaceBean.setSource(extra.getMethodComment().getSource());
        //添加额外信息
        interfaceBean.setCreateTime(System.currentTimeMillis());
        interfaceBean.setUpdateTime(System.currentTimeMillis());
        interfaceBean.setUnique(filter.unique(method,extra));
        interfaceBean.setEnableReqPackage(filter.enableReqPackage(method,extra)?1:0);
        interfaceBean.setEnableResPackage(filter.enableResPackage(method,extra)?1:0);
        interfaceBean.setRequestUrl(filter.requestUrl(method,extra));
    }

    @Override
    public InterfaceCreator setApiExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }
}
