package cn.easyutil.easyapi.logic.condition;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

public class MockProcess {
    private ReadMockTemplateFilter filter;
    private static final Object emptyObject = new Object();

    public static MockProcess with(ReadMockTemplateFilter filter){
        MockProcess mocker = new MockProcess();
        mocker.filter = filter;
        return mocker;
    }

    public Object mockByApiParams(String param){
        return mockByApiParams(JSONObject.parseObject(param, Map.class));
    }

    public Object mockByApiParams(Map<String,DocParamEntity> params){
        if(params==null || params.isEmpty()){
            return emptyObject;
        }
        Map<String,Object> objResult = new HashMap<>();
        List<Object> arrayResults = new ArrayList<>();
        //先处理处理最简单的返回逻辑，只有一个值的情况，如果存在nullkey只会有此单独一个节点
        if(params.containsKey(JavaBeanCreator.nullKey)){
            DocParamEntity entity = params.get(JavaBeanCreator.nullKey);
            JavaType javaType = JavaType.getType(entity.getJavaType());
            if(javaType!=JavaType.Object && javaType!=JavaType.ArrayObject){
                return mockValue(entity);
            }
            Map<String,DocParamEntity> children = (Map<String, DocParamEntity>) entity.getChildren();
            if(javaType == JavaType.Object){
                objResult.putAll(mockObject(children));
            }else{
                arrayResults.add(mockObject(children));
            }
        }else{
            objResult.putAll(mockObject(params));
        }
        //返回最终数据
        if(!objResult.isEmpty()){
            return objResult;
        }
        return arrayResults;
    }

    private Object mockOneParam(String key,DocParamEntity entity){
        JavaType javaType = JavaType.getType(entity.getJavaType());
        if(javaType!=JavaType.Object && javaType!=JavaType.ArrayObject){
            return mockValue(entity);
        }
        List<Object> arrayResults = new ArrayList<>();
        Map<String,DocParamEntity> children = (Map<String, DocParamEntity>) entity.getChildren();
        if(javaType == JavaType.Object){
            return mockObject(children);
        }
        arrayResults.add(mockObject(children));
        return arrayResults;
    }

    private Map<String,Object> mockObject(Map<String, DocParamEntity> children){
        Map<String,Object> result = new HashMap<>();
        Iterator<Map.Entry<String, DocParamEntity>> iterator = children.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, DocParamEntity> next = iterator.next();
            String key = next.getKey();
            DocParamEntity value = next.getValue();
            Object mockValue = mockOneParam(key, value);
            result.put(key, mockValue);
        }
        return result;
    }

    private Object mockValue(DocParamEntity entity){
        if(entity==null || entity.getJavaType()==null){
            return "";
        }
        String template = entity.getMockTemplate();
        JavaType javaType = JavaType.getType(entity.getJavaType());
        return filter.mock(template, javaType);
    }
}
