package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.dto.AfterScriptDto;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SelectGroupsDto;
import cn.easyutil.easyapi.interview.entity.HttpEntity;
import cn.easyutil.easyapi.interview.entity.ScriptParamBean;
import cn.easyutil.easyapi.interview.entity.ScriptSourceBean;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.js.ParseVariablesFactory;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.service.SimpleUnitService;
import cn.easyutil.easyapi.service.TestGroupService;
import cn.easyutil.easyapi.service.TestInfoService;
import cn.easyutil.easyapi.service.TestService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;

/**
 * 单元测试
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiUnitController")
@RequestMapping("/easyapi/doc/unit")
public class UnitController {

    @Resource(name = "easyapiTestGroupService")
    private TestGroupService groupService;

    @Resource(name = "easyapiTestService")
    private TestService testService;

    @Resource(name = "easyapiTestInfoService")
    private TestInfoService testInfoService;

    @Resource(name = "easyapiSimpleUnitService")
    private SimpleUnitService simpleUnitService;

    @Resource(name = "easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;

    @ApidocComment("条件查询接口测试分组列表")
    @PostMapping("/selectGroups")
    @AccessAuth(code = 1000)
    public EasyApiBindSqlResult<DBComplexTestGroupEntity> selectGroups(@RequestBody SelectGroupsDto dto){
        DBComplexTestGroupEntity query = new DBComplexTestGroupEntity();
        BeanUtils.copyProperties(dto, query);
        query.setName(null);
        EasyApiBindSqlResult page = groupService.page(EasyapiBindSQLExecuter.build(query)
                        .like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName())
                , dto.getCurrentPage(), dto.getShowCount()
        );
        return page;
    }

    @ApidocComment("添加接口测试分组")
    @PostMapping("/addGroups")
    @AccessAuth(code = 1000)
    public void addGroups(@RequestBody DBComplexTestGroupEntity entity){
        AssertUtil.isEmpty(entity.getName(), "分组名称不能为空");
        groupService.insert(entity);
    }

    @ApidocComment("修改接口测试分组")
    @PostMapping("/updateGroups")
    @AccessAuth(code = 1000)
    public void updateGroups(@RequestBody DBComplexTestGroupEntity entity){
        AssertUtil.isNull(entity.getId(), "分组id不能为空");
        groupService.update(entity);
    }

    @ApidocComment("删除接口测试分组")
    @PostMapping("/delGroups")
    @AccessAuth(code = 1000)
    public void delGroups(@RequestBody IdDto dto){
        groupService.deleteById(dto.getId());
    }

    @ApidocComment("条件查询接口测试历史")
    @PostMapping("/selectTests")
    @AccessAuth(code = 1000)
    public EasyApiBindSqlResult<DBComplexTestEntity> selectTests(@RequestBody SelectGroupsDto dto){
        DBComplexTestEntity query = new DBComplexTestEntity();
        BeanUtils.copyProperties(dto, query);
        EasyApiBindSqlResult page = testService.page(EasyapiBindSQLExecuter.build(query)
                        .like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName())
                , dto.getCurrentPage(), dto.getShowCount()
        );
        return page;
    }

    @ApidocComment("删除接口测试历史")
    @PostMapping("/delTests")
    @AccessAuth(code = 1000)
    public void delTests(@RequestBody IdDto dto){
        testService.deleteById(dto.getId());
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setTestId(dto.getId());
        testInfoService.delete(entity);
    }

    //----------------------------------------------------------------

    @ApidocComment("保存测试记录")
    @PostMapping("/saveUnit")
    @AccessAuth(code = 1000)
    public void saveUnit(@RequestBody DBSimpleUnitEntity entity){
        AssertUtil.isNull(entity.getInterfaceId(),"未知接口");
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setType(1);
        simpleUnitService.insert(entity);
    }

    @ApidocComment("获取接口测试历史记录")
    @AccessAuth(code = 1000)
    public List<DBSimpleUnitEntity> getAllUnit(@RequestBody IdDto dto){
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return simpleUnitService.list(EasyapiBindSQLExecuter.build(unit).orderBy(DBSimpleUnitEntity::getCreateTime,false));
    }

    @ApidocComment("获取上次接口执行相关参数")
    @AccessAuth(code = 1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody IdDto dto){
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setType(0);
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return simpleUnitService.get(unit);
    }

    @ApidocComment("修改执行结果")
    @AccessAuth(code = 1000)
    public void updateUnit(@RequestBody DBSimpleUnitEntity entity){
        AssertUtil.isNull(entity.getId(),"缺少id");
        simpleUnitService.update(entity);
    }

    @ApidocComment("删除测试记录")
    @AccessAuth(code = 1000)
    public void delUnit(@RequestBody IdDto dto){
        simpleUnitService.deleteById(dto.getId());
    }

    @ApidocComment("执行网络请求")
    @AccessAuth(code = 1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity){
        //将执行记录保存到DB
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        unit.setInterfaceId(interfaceId);
        unit.setUserId(userId);
        unit.setType(0);

        simpleUnitService.delete(unit);
        unit.setName("LATEST");
        unit.setRequestUrl(entity.getSaveUrl());
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setUseStyleType(entity.getUseStyleType());
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonPreScripts(entity.getSavePreScripts()==null?"[]":entity.getSavePreScripts());
        unit.setJsonPostScripts(entity.getSavePostScripts()==null?"[]":entity.getSavePostScripts());
        simpleUnitService.insert(unit);

        //执行远程请求
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();

        //记录请求结果
        String responseMsg = httpRes.getResponseMsg();
        unit.setJsonResponse(responseMsg);
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime-startTime);

        //准备返回数据
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        if(JsonUtil.isJson(httpRes.getResponseMsg())){
            //如果是json，则转成对象返回出去
            result.setResponseMsg(JsonUtil.jsonToMap(httpRes.getResponseMsg()));
        }
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime-startTime);
        result.setUnitId(unit.getId());

        unit.setJsonResponse(httpRes.getResponseMsg());
        simpleUnitService.update(unit);
        return result;
    }

    /**
     * 处理脚本
     * @param source
     * @param script
     * @return
     */
    private ScriptSourceBean doScript(ScriptSourceBean source,DBModuleScriptEntity script){
        String valType = script.getValType();
        String condition = JavaScriptExec.getVal(source, StringUtil.isEmpty(script.getCondition())?"true":script.getCondition());
        if(!Boolean.parseBoolean(condition)){
            return source;
        }
        //先判断DB的
        if(valType.equals("header") || valType.equals("env")){
            String val = JavaScriptExec.getVal(source, script.getScript());
            if(valType.equals("header")){
                //将变量值设置到header
                DBModuleHeaderEntity header = new DBModuleHeaderEntity();
                header.setKey(script.getValName());
                header.setVal(val);
                header.setModuleId(CurrentSession.getCurrentModuleId());
                header.setProjectId(CurrentSession.getCurrentProjectId());
                header.setUserId(CurrentSession.getCurrentUser().getId());
                simpleApidocController.addHeader(header);
            }else{
                DBMouduleEnvEntity env = new DBMouduleEnvEntity();
                env.setName(Optional.ofNullable(script.getDescription()).orElse(script.getValName()));
                env.setKey(script.getValName());
                env.setVal(val);
                env.setModuleId(CurrentSession.getCurrentModuleId());
                env.setProjectId(CurrentSession.getCurrentProjectId());
                env.setUserId(CurrentSession.getCurrentUser().getId());
                simpleApidocController.addEnv(env);
            }
            return source;
        }else{
            //剩下的全部交给参数处理
            return JavaScriptExec.parseParams(source,script);
        }
    }
}
