package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.CustomRemarkEnum;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadResponseParamApiFilter;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;

import java.lang.reflect.Method;
import java.lang.reflect.Type;

/**
 * 读取接口返回相关的api
 */
public class DefaultReadResponseParamApi extends ReadResponseParamApiFilter {

    @Override
    public Type returnType(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        return type;
    }

    @Override
    public boolean ignore(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        return false;
    }

    @Override
    public String description(Method method, ApiExtra extra) {
        return extra.getMethodComment().getReturnComment();
    }

    @Override
    public String mockTemplate(Method method, ApiExtra extra) {
        return CreatorCommonMethod.mockTemplate(method.getAnnotations());
    }

    @Override
    public boolean required(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        return false;
    }

    @Override
    public boolean show(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        return true;
    }

}
