package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.parameterized.GenericTypeBind;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;

/**
 * 读取请求参数相关的api
 *
 */
public abstract class ReadRequestParamApiFilter{

    /**
     * 是否忽略该参数
     * @param parameter
     * @param parameterType
     * @param parameterClass
     * @return
     */
    public abstract boolean ignore(Parameter parameter,Type parameterType,Class parameterClass, ApiExtra extra);

    /**
     * 读取参数名称
     * @param parameter
     * @return
     */
    public abstract String parameterName(Parameter parameter, ApiExtra extra);

    /**
     * 获取参数类型
     * @param parameter
     * @return
     */
    public abstract Type parameterType(Parameter parameter, ApiExtra extra);

    /**
     * 参数说明
     * @param parameter
     * @return
     */
    public abstract String description(Parameter parameter,String parameterName, ApiExtra extra);

    public abstract String mockTemplate(Parameter parameter, ApiExtra extra);

    public abstract boolean required(Parameter parameter, ApiExtra extra);

    public abstract boolean show(Parameter parameter, ApiExtra extra);

    /**
     * 参数校验,返回el表达式
     * @return
     */
    public abstract List<String> conditons(Parameter parameter, ApiExtra extra);
}
