package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

/**
 * 读取文档时的配置
 */
public abstract class ReadJavaBeanApiFilter{

    /**
     * 读取实体bean类型
     * @param type  实体bean类型
     * @return  实体bean类型
     */
    public abstract JavaType javaType(Class aClass, GenericTypeBind bind, Type type, ApiExtra extra);

    /**
     * 将实体bean的类型转换为其他类型进行解析
     * @param type  原始类型
     * @return  转换后的类型
     */
    public abstract Type type(Class aClass, GenericTypeBind bind, Type type, ApiExtra extra);

    /**
     * 读取实体bean字段说明
     * @param field 属性
     * @return  属性说明
     */
    public abstract String description(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra);

    /**
     * 读取实体bean的mock数据
     * @param field  注解上的mock配置
     * @return  实际mock值
     */
    public abstract String mockTemplate(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra);

    /**
     * 读取实体bean属性是否必须
     * @param field
     * @return  true：必须  false：非必须
     */
    public abstract boolean required(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra);

    /**
     * 读取实体bean属性是否显示
     */
    public abstract boolean show(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra);

    /**
     * 更新策略
     */
    public abstract RenewType renewType(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra);

    /**
     * 字段名称
     * @param aClass    字段类型
     * @param bind  绑定的泛型
     * @param field 字段
     * @param extra 冗余信息
     */
    public abstract String name(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra);

    /**
     * 读取实体bean属性是否忽略
     * @param field
     * @return  true：忽略  false：非忽略
     */
    public abstract boolean ignore(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra);

    /**
     * 参数校验,返回el表达式
     * @param aClass
     * @param bind
     * @param field
     * @return
     */
    public abstract List<String> conditons(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra);

}
